/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.cloudfront.cookie.CookiesForCannedPolicy;
import software.amazon.awssdk.services.cloudfront.cookie.CookiesForCustomPolicy;
import software.amazon.awssdk.services.cloudfront.internal.cookie.DefaultCookiesForCannedPolicy;
import software.amazon.awssdk.services.cloudfront.internal.cookie.DefaultCookiesForCustomPolicy;
import software.amazon.awssdk.services.cloudfront.internal.url.DefaultSignedUrl;
import software.amazon.awssdk.services.cloudfront.internal.utils.SigningUtils;
import software.amazon.awssdk.services.cloudfront.model.CannedSignerRequest;
import software.amazon.awssdk.services.cloudfront.model.CustomSignerRequest;
import software.amazon.awssdk.services.cloudfront.url.SignedUrl;

@Immutable
@ThreadSafe
@SdkPublicApi
public final class CloudFrontUtilities {
    private static final String KEY_PAIR_ID_KEY = "CloudFront-Key-Pair-Id";
    private static final String SIGNATURE_KEY = "CloudFront-Signature";
    private static final String EXPIRES_KEY = "CloudFront-Expires";
    private static final String POLICY_KEY = "CloudFront-Policy";

    private CloudFrontUtilities() {
    }

    public static CloudFrontUtilities create() {
        return new CloudFrontUtilities();
    }

    public SignedUrl getSignedUrlWithCannedPolicy(Consumer<CannedSignerRequest.Builder> request) {
        return this.getSignedUrlWithCannedPolicy((CannedSignerRequest)((CannedSignerRequest.Builder)CannedSignerRequest.builder().applyMutation(request)).build());
    }

    public SignedUrl getSignedUrlWithCannedPolicy(CannedSignerRequest request) {
        try {
            String resourceUrl = request.resourceUrl();
            String cannedPolicy = SigningUtils.buildCannedPolicy(resourceUrl, request.expirationDate());
            byte[] signatureBytes = SigningUtils.signWithSha1Rsa(cannedPolicy.getBytes(StandardCharsets.UTF_8), request.privateKey());
            String urlSafeSignature = SigningUtils.makeBytesUrlSafe(signatureBytes);
            URI uri = URI.create(resourceUrl);
            String protocol = uri.getScheme();
            String encodedPath = uri.getRawPath() + (uri.getQuery() != null ? "?" + uri.getRawQuery() + "&" : "?") + "Expires=" + request.expirationDate().getEpochSecond() + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + request.keyPairId();
            return DefaultSignedUrl.builder().protocol(protocol).domain(uri.getHost()).encodedPath(encodedPath).url(protocol + "://" + uri.getAuthority() + encodedPath).build();
        }
        catch (InvalidKeyException e) {
            throw SdkClientException.create((String)"Could not sign url", (Throwable)e);
        }
    }

    public SignedUrl getSignedUrlWithCustomPolicy(Consumer<CustomSignerRequest.Builder> request) {
        return this.getSignedUrlWithCustomPolicy((CustomSignerRequest)((CustomSignerRequest.Builder)CustomSignerRequest.builder().applyMutation(request)).build());
    }

    public SignedUrl getSignedUrlWithCustomPolicy(CustomSignerRequest request) {
        try {
            String resourceUrl = request.resourceUrl();
            String policy = SigningUtils.buildCustomPolicyForSignedUrl(request.resourceUrl(), request.activeDate(), request.expirationDate(), request.ipRange());
            byte[] signatureBytes = SigningUtils.signWithSha1Rsa(policy.getBytes(StandardCharsets.UTF_8), request.privateKey());
            String urlSafePolicy = SigningUtils.makeStringUrlSafe(policy);
            String urlSafeSignature = SigningUtils.makeBytesUrlSafe(signatureBytes);
            URI uri = URI.create(resourceUrl);
            String protocol = uri.getScheme();
            String encodedPath = uri.getRawPath() + (uri.getQuery() != null ? "?" + uri.getRawQuery() + "&" : "?") + "Policy=" + urlSafePolicy + "&Signature=" + urlSafeSignature + "&Key-Pair-Id=" + request.keyPairId();
            return DefaultSignedUrl.builder().protocol(protocol).domain(uri.getHost()).encodedPath(encodedPath).url(protocol + "://" + uri.getAuthority() + encodedPath).build();
        }
        catch (InvalidKeyException e) {
            throw SdkClientException.create((String)"Could not sign url", (Throwable)e);
        }
    }

    public CookiesForCannedPolicy getCookiesForCannedPolicy(Consumer<CannedSignerRequest.Builder> request) {
        return this.getCookiesForCannedPolicy((CannedSignerRequest)((CannedSignerRequest.Builder)CannedSignerRequest.builder().applyMutation(request)).build());
    }

    public CookiesForCannedPolicy getCookiesForCannedPolicy(CannedSignerRequest request) {
        try {
            String cannedPolicy = SigningUtils.buildCannedPolicy(request.resourceUrl(), request.expirationDate());
            byte[] signatureBytes = SigningUtils.signWithSha1Rsa(cannedPolicy.getBytes(StandardCharsets.UTF_8), request.privateKey());
            String urlSafeSignature = SigningUtils.makeBytesUrlSafe(signatureBytes);
            String expiry = String.valueOf(request.expirationDate().getEpochSecond());
            return (CookiesForCannedPolicy)DefaultCookiesForCannedPolicy.builder().resourceUrl(request.resourceUrl()).keyPairIdHeaderValue("CloudFront-Key-Pair-Id=" + request.keyPairId()).signatureHeaderValue("CloudFront-Signature=" + urlSafeSignature).expiresHeaderValue("CloudFront-Expires=" + expiry).build();
        }
        catch (InvalidKeyException e) {
            throw SdkClientException.create((String)"Could not sign canned policy cookie", (Throwable)e);
        }
    }

    public CookiesForCustomPolicy getCookiesForCustomPolicy(Consumer<CustomSignerRequest.Builder> request) {
        return this.getCookiesForCustomPolicy((CustomSignerRequest)((CustomSignerRequest.Builder)CustomSignerRequest.builder().applyMutation(request)).build());
    }

    public CookiesForCustomPolicy getCookiesForCustomPolicy(CustomSignerRequest request) {
        try {
            String policy = SigningUtils.buildCustomPolicy(request.resourceUrl(), request.activeDate(), request.expirationDate(), request.ipRange());
            byte[] signatureBytes = SigningUtils.signWithSha1Rsa(policy.getBytes(StandardCharsets.UTF_8), request.privateKey());
            String urlSafePolicy = SigningUtils.makeStringUrlSafe(policy);
            String urlSafeSignature = SigningUtils.makeBytesUrlSafe(signatureBytes);
            return (CookiesForCustomPolicy)DefaultCookiesForCustomPolicy.builder().resourceUrl(request.resourceUrl()).keyPairIdHeaderValue("CloudFront-Key-Pair-Id=" + request.keyPairId()).signatureHeaderValue("CloudFront-Signature=" + urlSafeSignature).policyHeaderValue("CloudFront-Policy=" + urlSafePolicy).build();
        }
        catch (InvalidKeyException e) {
            throw SdkClientException.create((String)"Could not sign custom policy cookie", (Throwable)e);
        }
    }
}

