/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudFrontOriginAccessIdentitySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CloudFrontOriginAccessIdentitySummary.getter(CloudFrontOriginAccessIdentitySummary::id)).setter(CloudFrontOriginAccessIdentitySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> S3_CANONICAL_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3CanonicalUserId").getter(CloudFrontOriginAccessIdentitySummary.getter(CloudFrontOriginAccessIdentitySummary::s3CanonicalUserId)).setter(CloudFrontOriginAccessIdentitySummary.setter(Builder::s3CanonicalUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CanonicalUserId").unmarshallLocationName("S3CanonicalUserId").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CloudFrontOriginAccessIdentitySummary.getter(CloudFrontOriginAccessIdentitySummary::comment)).setter(CloudFrontOriginAccessIdentitySummary.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, S3_CANONICAL_USER_ID_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudFrontOriginAccessIdentitySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String s3CanonicalUserId;
    private final String comment;

    private CloudFrontOriginAccessIdentitySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.comment = builder.comment;
    }

    public final String id() {
        return this.id;
    }

    public final String s3CanonicalUserId() {
        return this.s3CanonicalUserId;
    }

    public final String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3CanonicalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentitySummary)) {
            return false;
        }
        CloudFrontOriginAccessIdentitySummary other = (CloudFrontOriginAccessIdentitySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.s3CanonicalUserId(), other.s3CanonicalUserId()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"CloudFrontOriginAccessIdentitySummary").add("Id", (Object)this.id()).add("S3CanonicalUserId", (Object)this.s3CanonicalUserId()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "S3CanonicalUserId": {
                return Optional.ofNullable(clazz.cast(this.s3CanonicalUserId()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("S3CanonicalUserId", S3_CANONICAL_USER_ID_FIELD);
        map.put("Comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudFrontOriginAccessIdentitySummary, T> g) {
        return obj -> g.apply((CloudFrontOriginAccessIdentitySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String s3CanonicalUserId;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentitySummary model) {
            this.id(model.id);
            this.s3CanonicalUserId(model.s3CanonicalUserId);
            this.comment(model.comment);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getS3CanonicalUserId() {
            return this.s3CanonicalUserId;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public CloudFrontOriginAccessIdentitySummary build() {
            return new CloudFrontOriginAccessIdentitySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
        public Builder id(String var1);

        public Builder s3CanonicalUserId(String var1);

        public Builder comment(String var1);
    }
}

