/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ConflictingAliasesList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConflictingAliasesResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, ListConflictingAliasesResponse> {
    private static final SdkField<ConflictingAliasesList> CONFLICTING_ALIASES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConflictingAliasesList").getter(ListConflictingAliasesResponse.getter(ListConflictingAliasesResponse::conflictingAliasesList)).setter(ListConflictingAliasesResponse.setter(Builder::conflictingAliasesList)).constructor(ConflictingAliasesList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictingAliasesList").unmarshallLocationName("ConflictingAliasesList").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICTING_ALIASES_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConflictingAliasesResponse.memberNameToFieldInitializer();
    private final ConflictingAliasesList conflictingAliasesList;

    private ListConflictingAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.conflictingAliasesList = builder.conflictingAliasesList;
    }

    public final ConflictingAliasesList conflictingAliasesList() {
        return this.conflictingAliasesList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictingAliasesList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConflictingAliasesResponse)) {
            return false;
        }
        ListConflictingAliasesResponse other = (ListConflictingAliasesResponse)((Object)obj);
        return Objects.equals(this.conflictingAliasesList(), other.conflictingAliasesList());
    }

    public final String toString() {
        return ToString.builder((String)"ListConflictingAliasesResponse").add("ConflictingAliasesList", (Object)this.conflictingAliasesList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConflictingAliasesList": {
                return Optional.ofNullable(clazz.cast(this.conflictingAliasesList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<ConflictingAliasesList>> map = new HashMap<String, SdkField<ConflictingAliasesList>>();
        map.put("ConflictingAliasesList", CONFLICTING_ALIASES_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConflictingAliasesResponse, T> g) {
        return obj -> g.apply((ListConflictingAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ConflictingAliasesList conflictingAliasesList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConflictingAliasesResponse model) {
            super(model);
            this.conflictingAliasesList(model.conflictingAliasesList);
        }

        public final ConflictingAliasesList.Builder getConflictingAliasesList() {
            return this.conflictingAliasesList != null ? this.conflictingAliasesList.toBuilder() : null;
        }

        public final void setConflictingAliasesList(ConflictingAliasesList.BuilderImpl conflictingAliasesList) {
            this.conflictingAliasesList = conflictingAliasesList != null ? conflictingAliasesList.build() : null;
        }

        @Override
        public final Builder conflictingAliasesList(ConflictingAliasesList conflictingAliasesList) {
            this.conflictingAliasesList = conflictingAliasesList;
            return this;
        }

        @Override
        public ListConflictingAliasesResponse build() {
            return new ListConflictingAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConflictingAliasesResponse> {
        public Builder conflictingAliasesList(ConflictingAliasesList var1);

        default public Builder conflictingAliasesList(Consumer<ConflictingAliasesList.Builder> conflictingAliasesList) {
            return this.conflictingAliasesList((ConflictingAliasesList)((ConflictingAliasesList.Builder)ConflictingAliasesList.builder().applyMutation(conflictingAliasesList)).build());
        }
    }
}

