/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DomainConflict;
import software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDomainConflictsResponse;

public class ListDomainConflictsPublisher
implements SdkPublisher<ListDomainConflictsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDomainConflictsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainConflictsPublisher(CloudFrontAsyncClient client, ListDomainConflictsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainConflictsPublisher(CloudFrontAsyncClient client, ListDomainConflictsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainConflictsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainConflictsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainConflict> domainConflicts() {
        Function<ListDomainConflictsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainConflicts() != null) {
                return response.domainConflicts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainConflictsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainConflictsResponseFetcher
    implements AsyncPageFetcher<ListDomainConflictsResponse> {
        private ListDomainConflictsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainConflictsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListDomainConflictsResponse> nextPage(ListDomainConflictsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainConflictsPublisher.this.client.listDomainConflicts(ListDomainConflictsPublisher.this.firstRequest);
            }
            return ListDomainConflictsPublisher.this.client.listDomainConflicts((ListDomainConflictsRequest)((Object)ListDomainConflictsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

