/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.IpamCidrStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpamCidrConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpamCidrConfig> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(IpamCidrConfig.getter(IpamCidrConfig::cidr)).setter(IpamCidrConfig.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").unmarshallLocationName("Cidr").build()}).build();
    private static final SdkField<String> IPAM_POOL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpamPoolArn").getter(IpamCidrConfig.getter(IpamCidrConfig::ipamPoolArn)).setter(IpamCidrConfig.setter(Builder::ipamPoolArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPoolArn").unmarshallLocationName("IpamPoolArn").build()}).build();
    private static final SdkField<String> ANYCAST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnycastIp").getter(IpamCidrConfig.getter(IpamCidrConfig::anycastIp)).setter(IpamCidrConfig.setter(Builder::anycastIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIp").unmarshallLocationName("AnycastIp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(IpamCidrConfig.getter(IpamCidrConfig::statusAsString)).setter(IpamCidrConfig.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, IPAM_POOL_ARN_FIELD, ANYCAST_IP_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpamCidrConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cidr;
    private final String ipamPoolArn;
    private final String anycastIp;
    private final String status;

    private IpamCidrConfig(BuilderImpl builder) {
        this.cidr = builder.cidr;
        this.ipamPoolArn = builder.ipamPoolArn;
        this.anycastIp = builder.anycastIp;
        this.status = builder.status;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String ipamPoolArn() {
        return this.ipamPoolArn;
    }

    public final String anycastIp() {
        return this.anycastIp;
    }

    public final IpamCidrStatus status() {
        return IpamCidrStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPoolArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anycastIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamCidrConfig)) {
            return false;
        }
        IpamCidrConfig other = (IpamCidrConfig)obj;
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.ipamPoolArn(), other.ipamPoolArn()) && Objects.equals(this.anycastIp(), other.anycastIp()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IpamCidrConfig").add("Cidr", (Object)this.cidr()).add("IpamPoolArn", (Object)this.ipamPoolArn()).add("AnycastIp", (Object)this.anycastIp()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "IpamPoolArn": {
                return Optional.ofNullable(clazz.cast(this.ipamPoolArn()));
            }
            case "AnycastIp": {
                return Optional.ofNullable(clazz.cast(this.anycastIp()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Cidr", CIDR_FIELD);
        map.put("IpamPoolArn", IPAM_POOL_ARN_FIELD);
        map.put("AnycastIp", ANYCAST_IP_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamCidrConfig, T> g) {
        return obj -> g.apply((IpamCidrConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cidr;
        private String ipamPoolArn;
        private String anycastIp;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(IpamCidrConfig model) {
            this.cidr(model.cidr);
            this.ipamPoolArn(model.ipamPoolArn);
            this.anycastIp(model.anycastIp);
            this.status(model.status);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpamPoolArn() {
            return this.ipamPoolArn;
        }

        public final void setIpamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
        }

        @Override
        public final Builder ipamPoolArn(String ipamPoolArn) {
            this.ipamPoolArn = ipamPoolArn;
            return this;
        }

        public final String getAnycastIp() {
            return this.anycastIp;
        }

        public final void setAnycastIp(String anycastIp) {
            this.anycastIp = anycastIp;
        }

        @Override
        public final Builder anycastIp(String anycastIp) {
            this.anycastIp = anycastIp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IpamCidrStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public IpamCidrConfig build() {
            return new IpamCidrConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpamCidrConfig> {
        public Builder cidr(String var1);

        public Builder ipamPoolArn(String var1);

        public Builder anycastIp(String var1);

        public Builder status(String var1);

        public Builder status(IpamCidrStatus var1);
    }
}

