/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a backup of an AWS CloudHSM cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Backup implements SdkPojo, Serializable, ToCopyableBuilder<Backup.Builder, Backup> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> BACKUP_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::backupStateAsString)).setter(setter(Builder::backupState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupState").build()).build();

    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Backup::createTimestamp)).setter(setter(Builder::createTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()).build();

    private static final SdkField<Instant> COPY_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Backup::copyTimestamp)).setter(setter(Builder::copyTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTimestamp").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> SOURCE_BACKUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::sourceBackup)).setter(setter(Builder::sourceBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackup").build()).build();

    private static final SdkField<String> SOURCE_CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Backup::sourceCluster)).setter(setter(Builder::sourceCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCluster").build()).build();

    private static final SdkField<Instant> DELETE_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Backup::deleteTimestamp)).setter(setter(Builder::deleteTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            BACKUP_STATE_FIELD, CLUSTER_ID_FIELD, CREATE_TIMESTAMP_FIELD, COPY_TIMESTAMP_FIELD, SOURCE_REGION_FIELD,
            SOURCE_BACKUP_FIELD, SOURCE_CLUSTER_FIELD, DELETE_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String backupId;

    private final String backupState;

    private final String clusterId;

    private final Instant createTimestamp;

    private final Instant copyTimestamp;

    private final String sourceRegion;

    private final String sourceBackup;

    private final String sourceCluster;

    private final Instant deleteTimestamp;

    private Backup(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.backupState = builder.backupState;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.copyTimestamp = builder.copyTimestamp;
        this.sourceRegion = builder.sourceRegion;
        this.sourceBackup = builder.sourceBackup;
        this.sourceCluster = builder.sourceCluster;
        this.deleteTimestamp = builder.deleteTimestamp;
    }

    /**
     * <p>
     * The identifier (ID) of the backup.
     * </p>
     * 
     * @return The identifier (ID) of the backup.
     */
    public String backupId() {
        return backupId;
    }

    /**
     * <p>
     * The state of the backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupState} will
     * return {@link BackupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStateAsString}.
     * </p>
     * 
     * @return The state of the backup.
     * @see BackupState
     */
    public BackupState backupState() {
        return BackupState.fromValue(backupState);
    }

    /**
     * <p>
     * The state of the backup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #backupState} will
     * return {@link BackupState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #backupStateAsString}.
     * </p>
     * 
     * @return The state of the backup.
     * @see BackupState
     */
    public String backupStateAsString() {
        return backupState;
    }

    /**
     * <p>
     * The identifier (ID) of the cluster that was backed up.
     * </p>
     * 
     * @return The identifier (ID) of the cluster that was backed up.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The date and time when the backup was created.
     * </p>
     * 
     * @return The date and time when the backup was created.
     */
    public Instant createTimestamp() {
        return createTimestamp;
    }

    /**
     * Returns the value of the CopyTimestamp property for this object.
     * 
     * @return The value of the CopyTimestamp property for this object.
     */
    public Instant copyTimestamp() {
        return copyTimestamp;
    }

    /**
     * Returns the value of the SourceRegion property for this object.
     * 
     * @return The value of the SourceRegion property for this object.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    /**
     * Returns the value of the SourceBackup property for this object.
     * 
     * @return The value of the SourceBackup property for this object.
     */
    public String sourceBackup() {
        return sourceBackup;
    }

    /**
     * Returns the value of the SourceCluster property for this object.
     * 
     * @return The value of the SourceCluster property for this object.
     */
    public String sourceCluster() {
        return sourceCluster;
    }

    /**
     * <p>
     * The date and time when the backup will be permanently deleted.
     * </p>
     * 
     * @return The date and time when the backup will be permanently deleted.
     */
    public Instant deleteTimestamp() {
        return deleteTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(backupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceBackup());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCluster());
        hashCode = 31 * hashCode + Objects.hashCode(deleteTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(backupStateAsString(), other.backupStateAsString())
                && Objects.equals(clusterId(), other.clusterId()) && Objects.equals(createTimestamp(), other.createTimestamp())
                && Objects.equals(copyTimestamp(), other.copyTimestamp()) && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(sourceBackup(), other.sourceBackup()) && Objects.equals(sourceCluster(), other.sourceCluster())
                && Objects.equals(deleteTimestamp(), other.deleteTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Backup").add("BackupId", backupId()).add("BackupState", backupStateAsString())
                .add("ClusterId", clusterId()).add("CreateTimestamp", createTimestamp()).add("CopyTimestamp", copyTimestamp())
                .add("SourceRegion", sourceRegion()).add("SourceBackup", sourceBackup()).add("SourceCluster", sourceCluster())
                .add("DeleteTimestamp", deleteTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "BackupState":
            return Optional.ofNullable(clazz.cast(backupStateAsString()));
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "CreateTimestamp":
            return Optional.ofNullable(clazz.cast(createTimestamp()));
        case "CopyTimestamp":
            return Optional.ofNullable(clazz.cast(copyTimestamp()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "SourceBackup":
            return Optional.ofNullable(clazz.cast(sourceBackup()));
        case "SourceCluster":
            return Optional.ofNullable(clazz.cast(sourceCluster()));
        case "DeleteTimestamp":
            return Optional.ofNullable(clazz.cast(deleteTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Backup, T> g) {
        return obj -> g.apply((Backup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Backup> {
        /**
         * <p>
         * The identifier (ID) of the backup.
         * </p>
         * 
         * @param backupId
         *        The identifier (ID) of the backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * The state of the backup.
         * </p>
         * 
         * @param backupState
         *        The state of the backup.
         * @see BackupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupState
         */
        Builder backupState(String backupState);

        /**
         * <p>
         * The state of the backup.
         * </p>
         * 
         * @param backupState
         *        The state of the backup.
         * @see BackupState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupState
         */
        Builder backupState(BackupState backupState);

        /**
         * <p>
         * The identifier (ID) of the cluster that was backed up.
         * </p>
         * 
         * @param clusterId
         *        The identifier (ID) of the cluster that was backed up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The date and time when the backup was created.
         * </p>
         * 
         * @param createTimestamp
         *        The date and time when the backup was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTimestamp(Instant createTimestamp);

        /**
         * Sets the value of the CopyTimestamp property for this object.
         *
         * @param copyTimestamp
         *        The new value for the CopyTimestamp property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTimestamp(Instant copyTimestamp);

        /**
         * Sets the value of the SourceRegion property for this object.
         *
         * @param sourceRegion
         *        The new value for the SourceRegion property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * Sets the value of the SourceBackup property for this object.
         *
         * @param sourceBackup
         *        The new value for the SourceBackup property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceBackup(String sourceBackup);

        /**
         * Sets the value of the SourceCluster property for this object.
         *
         * @param sourceCluster
         *        The new value for the SourceCluster property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCluster(String sourceCluster);

        /**
         * <p>
         * The date and time when the backup will be permanently deleted.
         * </p>
         * 
         * @param deleteTimestamp
         *        The date and time when the backup will be permanently deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteTimestamp(Instant deleteTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String backupId;

        private String backupState;

        private String clusterId;

        private Instant createTimestamp;

        private Instant copyTimestamp;

        private String sourceRegion;

        private String sourceBackup;

        private String sourceCluster;

        private Instant deleteTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            backupId(model.backupId);
            backupState(model.backupState);
            clusterId(model.clusterId);
            createTimestamp(model.createTimestamp);
            copyTimestamp(model.copyTimestamp);
            sourceRegion(model.sourceRegion);
            sourceBackup(model.sourceBackup);
            sourceCluster(model.sourceCluster);
            deleteTimestamp(model.deleteTimestamp);
        }

        public final String getBackupId() {
            return backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        public final String getBackupStateAsString() {
            return backupState;
        }

        @Override
        public final Builder backupState(String backupState) {
            this.backupState = backupState;
            return this;
        }

        @Override
        public final Builder backupState(BackupState backupState) {
            this.backupState(backupState == null ? null : backupState.toString());
            return this;
        }

        public final void setBackupState(String backupState) {
            this.backupState = backupState;
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Instant getCopyTimestamp() {
            return copyTimestamp;
        }

        @Override
        public final Builder copyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
            return this;
        }

        public final void setCopyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceBackup() {
            return sourceBackup;
        }

        @Override
        public final Builder sourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
            return this;
        }

        public final void setSourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
        }

        public final String getSourceCluster() {
            return sourceCluster;
        }

        @Override
        public final Builder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        public final void setSourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
        }

        public final Instant getDeleteTimestamp() {
            return deleteTimestamp;
        }

        @Override
        public final Builder deleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this;
        }

        public final void setDeleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
        }

        @Override
        public Backup build() {
            return new Backup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
