/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyBackupToRegionRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<CopyBackupToRegionRequest.Builder, CopyBackupToRegionRequest> {
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyBackupToRegionRequest::destinationRegion)).setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyBackupToRegionRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REGION_FIELD,
            BACKUP_ID_FIELD));

    private final String destinationRegion;

    private final String backupId;

    private CopyBackupToRegionRequest(BuilderImpl builder) {
        super(builder);
        this.destinationRegion = builder.destinationRegion;
        this.backupId = builder.backupId;
    }

    /**
     * <p>
     * The AWS region that will contain your copied CloudHSM cluster backup.
     * </p>
     * 
     * @return The AWS region that will contain your copied CloudHSM cluster backup.
     */
    public String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The ID of the backup that will be copied to the destination region.
     * </p>
     * 
     * @return The ID of the backup that will be copied to the destination region.
     */
    public String backupId() {
        return backupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyBackupToRegionRequest)) {
            return false;
        }
        CopyBackupToRegionRequest other = (CopyBackupToRegionRequest) obj;
        return Objects.equals(destinationRegion(), other.destinationRegion()) && Objects.equals(backupId(), other.backupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CopyBackupToRegionRequest").add("DestinationRegion", destinationRegion())
                .add("BackupId", backupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyBackupToRegionRequest, T> g) {
        return obj -> g.apply((CopyBackupToRegionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CopyBackupToRegionRequest> {
        /**
         * <p>
         * The AWS region that will contain your copied CloudHSM cluster backup.
         * </p>
         * 
         * @param destinationRegion
         *        The AWS region that will contain your copied CloudHSM cluster backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The ID of the backup that will be copied to the destination region.
         * </p>
         * 
         * @param backupId
         *        The ID of the backup that will be copied to the destination region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String destinationRegion;

        private String backupId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyBackupToRegionRequest model) {
            super(model);
            destinationRegion(model.destinationRegion);
            backupId(model.backupId);
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final String getBackupId() {
            return backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyBackupToRegionRequest build() {
            return new CopyBackupToRegionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
