/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBackupsResponse extends CloudHsmV2Response implements
        ToCopyableBuilder<DescribeBackupsResponse.Builder, DescribeBackupsResponse> {
    private static final SdkField<List<Backup>> BACKUPS_FIELD = SdkField
            .<List<Backup>> builder(MarshallingType.LIST)
            .getter(getter(DescribeBackupsResponse::backups))
            .setter(setter(Builder::backups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Backups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Backup> builder(MarshallingType.SDK_POJO)
                                            .constructor(Backup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeBackupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Backup> backups;

    private final String nextToken;

    private DescribeBackupsResponse(BuilderImpl builder) {
        super(builder);
        this.backups = builder.backups;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Backups property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBackups() {
        return backups != null && !(backups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of backups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of backups.
     */
    public List<Backup> backups() {
        return backups;
    }

    /**
     * <p>
     * An opaque string that indicates that the response contains only a subset of backups. Use this value in a
     * subsequent <code>DescribeBackups</code> request to get more backups.
     * </p>
     * 
     * @return An opaque string that indicates that the response contains only a subset of backups. Use this value in a
     *         subsequent <code>DescribeBackups</code> request to get more backups.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBackupsResponse)) {
            return false;
        }
        DescribeBackupsResponse other = (DescribeBackupsResponse) obj;
        return Objects.equals(backups(), other.backups()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeBackupsResponse").add("Backups", backups()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Backups":
            return Optional.ofNullable(clazz.cast(backups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBackupsResponse, T> g) {
        return obj -> g.apply((DescribeBackupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeBackupsResponse> {
        /**
         * <p>
         * A list of backups.
         * </p>
         * 
         * @param backups
         *        A list of backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backups(Collection<Backup> backups);

        /**
         * <p>
         * A list of backups.
         * </p>
         * 
         * @param backups
         *        A list of backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backups(Backup... backups);

        /**
         * <p>
         * A list of backups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Backup>.Builder} avoiding the need to
         * create one manually via {@link List<Backup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Backup>.Builder#build()} is called immediately and its
         * result is passed to {@link #backups(List<Backup>)}.
         * 
         * @param backups
         *        a consumer that will call methods on {@link List<Backup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backups(List<Backup>)
         */
        Builder backups(Consumer<Backup.Builder>... backups);

        /**
         * <p>
         * An opaque string that indicates that the response contains only a subset of backups. Use this value in a
         * subsequent <code>DescribeBackups</code> request to get more backups.
         * </p>
         * 
         * @param nextToken
         *        An opaque string that indicates that the response contains only a subset of backups. Use this value in
         *        a subsequent <code>DescribeBackups</code> request to get more backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudHsmV2Response.BuilderImpl implements Builder {
        private List<Backup> backups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBackupsResponse model) {
            super(model);
            backups(model.backups);
            nextToken(model.nextToken);
        }

        public final Collection<Backup.Builder> getBackups() {
            return backups != null ? backups.stream().map(Backup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backups(Collection<Backup> backups) {
            this.backups = BackupsCopier.copy(backups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backups(Backup... backups) {
            backups(Arrays.asList(backups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backups(Consumer<Backup.Builder>... backups) {
            backups(Stream.of(backups).map(c -> Backup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackups(Collection<Backup.BuilderImpl> backups) {
            this.backups = BackupsCopier.copyFromBuilder(backups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBackupsResponse build() {
            return new DescribeBackupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
