/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsRequest extends CloudHsmV2Request implements
        ToCopyableBuilder<ListTagsRequest.Builder, ListTagsRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTagsRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListTagsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListTagsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String resourceId;

    private final String nextToken;

    private final Integer maxResults;

    private ListTagsRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use
     * <a>DescribeClusters</a>.
     * </p>
     * 
     * @return The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use
     *         <a>DescribeClusters</a>.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The <code>NextToken</code> value that you received in the previous response. Use this value to get more tags.
     * </p>
     * 
     * @return The <code>NextToken</code> value that you received in the previous response. Use this value to get more
     *         tags.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of tags to return in the response. When there are more tags than the number you specify, the
     * response contains a <code>NextToken</code> value.
     * </p>
     * 
     * @return The maximum number of tags to return in the response. When there are more tags than the number you
     *         specify, the response contains a <code>NextToken</code> value.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsRequest)) {
            return false;
        }
        ListTagsRequest other = (ListTagsRequest) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTagsRequest").add("ResourceId", resourceId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsRequest, T> g) {
        return obj -> g.apply((ListTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudHsmV2Request.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsRequest> {
        /**
         * <p>
         * The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use
         * <a>DescribeClusters</a>.
         * </p>
         * 
         * @param resourceId
         *        The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use
         *        <a>DescribeClusters</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The <code>NextToken</code> value that you received in the previous response. Use this value to get more tags.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> value that you received in the previous response. Use this value to get
         *        more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of tags to return in the response. When there are more tags than the number you specify,
         * the response contains a <code>NextToken</code> value.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tags to return in the response. When there are more tags than the number you
         *        specify, the response contains a <code>NextToken</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudHsmV2Request.BuilderImpl implements Builder {
        private String resourceId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsRequest model) {
            super(model);
            resourceId(model.resourceId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsRequest build() {
            return new ListTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
