/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal.task;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.CloudWatchMetricLogger;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.MetricUploader;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.transform.MetricCollectionAggregator;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public class UploadMetricsTasks
implements Callable<CompletableFuture<?>> {
    private final MetricCollectionAggregator collectionAggregator;
    private final MetricUploader uploader;
    private int maximumRequestsPerFlush;

    public UploadMetricsTasks(MetricCollectionAggregator collectionAggregator, MetricUploader uploader, int maximumRequestsPerFlush) {
        this.collectionAggregator = collectionAggregator;
        this.uploader = uploader;
        this.maximumRequestsPerFlush = maximumRequestsPerFlush;
    }

    @Override
    public CompletableFuture<?> call() {
        try {
            List<PutMetricDataRequest> allRequests;
            List<PutMetricDataRequest> requests = allRequests = this.collectionAggregator.getRequests();
            if (requests.size() > this.maximumRequestsPerFlush) {
                CloudWatchMetricLogger.METRIC_LOGGER.warn(() -> "Maximum AWS SDK client-side metric call count exceeded: " + allRequests.size() + " > " + this.maximumRequestsPerFlush + ". Some metric requests will be dropped. This occurs when the caller has configured too many metrics or too unique of dimensions without an associated increase in the maximum-calls-per-upload configured on the publisher.");
                requests = requests.subList(0, this.maximumRequestsPerFlush);
            }
            return this.uploader.upload(requests);
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }
}

