/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageSummary;

public class ListPackagesIterable
implements SdkIterable<ListPackagesResponse> {
    private final CodeartifactClient client;
    private final ListPackagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackagesIterable(CodeartifactClient client, ListPackagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackagesResponseFetcher();
    }

    public Iterator<ListPackagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PackageSummary> packages() {
        Function<ListPackagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.packages() != null) {
                return response.packages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackagesResponseFetcher
    implements SyncPageFetcher<ListPackagesResponse> {
        private ListPackagesResponseFetcher() {
        }

        public boolean hasNextPage(ListPackagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackagesResponse nextPage(ListPackagesResponse previousPage) {
            if (previousPage == null) {
                return ListPackagesIterable.this.client.listPackages(ListPackagesIterable.this.firstRequest);
            }
            return ListPackagesIterable.this.client.listPackages((ListPackagesRequest)((Object)ListPackagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

