/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.ExternalConnectionStatus;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryExternalConnectionInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryExternalConnectionInfo> {
    private static final SdkField<String> EXTERNAL_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalConnectionName").getter(RepositoryExternalConnectionInfo.getter(RepositoryExternalConnectionInfo::externalConnectionName)).setter(RepositoryExternalConnectionInfo.setter(Builder::externalConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalConnectionName").build()}).build();
    private static final SdkField<String> PACKAGE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageFormat").getter(RepositoryExternalConnectionInfo.getter(RepositoryExternalConnectionInfo::packageFormatAsString)).setter(RepositoryExternalConnectionInfo.setter(Builder::packageFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageFormat").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RepositoryExternalConnectionInfo.getter(RepositoryExternalConnectionInfo::statusAsString)).setter(RepositoryExternalConnectionInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_CONNECTION_NAME_FIELD, PACKAGE_FORMAT_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String externalConnectionName;
    private final String packageFormat;
    private final String status;

    private RepositoryExternalConnectionInfo(BuilderImpl builder) {
        this.externalConnectionName = builder.externalConnectionName;
        this.packageFormat = builder.packageFormat;
        this.status = builder.status;
    }

    public final String externalConnectionName() {
        return this.externalConnectionName;
    }

    public final PackageFormat packageFormat() {
        return PackageFormat.fromValue(this.packageFormat);
    }

    public final String packageFormatAsString() {
        return this.packageFormat;
    }

    public final ExternalConnectionStatus status() {
        return ExternalConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.externalConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryExternalConnectionInfo)) {
            return false;
        }
        RepositoryExternalConnectionInfo other = (RepositoryExternalConnectionInfo)obj;
        return Objects.equals(this.externalConnectionName(), other.externalConnectionName()) && Objects.equals(this.packageFormatAsString(), other.packageFormatAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryExternalConnectionInfo").add("ExternalConnectionName", (Object)this.externalConnectionName()).add("PackageFormat", (Object)this.packageFormatAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalConnectionName": {
                return Optional.ofNullable(clazz.cast(this.externalConnectionName()));
            }
            case "packageFormat": {
                return Optional.ofNullable(clazz.cast(this.packageFormatAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryExternalConnectionInfo, T> g) {
        return obj -> g.apply((RepositoryExternalConnectionInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String externalConnectionName;
        private String packageFormat;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryExternalConnectionInfo model) {
            this.externalConnectionName(model.externalConnectionName);
            this.packageFormat(model.packageFormat);
            this.status(model.status);
        }

        public final String getExternalConnectionName() {
            return this.externalConnectionName;
        }

        @Override
        public final Builder externalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
            return this;
        }

        public final void setExternalConnectionName(String externalConnectionName) {
            this.externalConnectionName = externalConnectionName;
        }

        public final String getPackageFormat() {
            return this.packageFormat;
        }

        @Override
        public final Builder packageFormat(String packageFormat) {
            this.packageFormat = packageFormat;
            return this;
        }

        @Override
        public final Builder packageFormat(PackageFormat packageFormat) {
            this.packageFormat(packageFormat == null ? null : packageFormat.toString());
            return this;
        }

        public final void setPackageFormat(String packageFormat) {
            this.packageFormat = packageFormat;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExternalConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public RepositoryExternalConnectionInfo build() {
            return new RepositoryExternalConnectionInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryExternalConnectionInfo> {
        public Builder externalConnectionName(String var1);

        public Builder packageFormat(String var1);

        public Builder packageFormat(PackageFormat var1);

        public Builder status(String var1);

        public Builder status(ExternalConnectionStatus var1);
    }
}

