/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.AssetSummary;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublishPackageVersionResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, PublishPackageVersionResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::formatAsString)).setter(PublishPackageVersionResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::namespace)).setter(PublishPackageVersionResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::packageValue)).setter(PublishPackageVersionResponse.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::version)).setter(PublishPackageVersionResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionRevision").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::versionRevision)).setter(PublishPackageVersionResponse.setter(Builder::versionRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::statusAsString)).setter(PublishPackageVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<AssetSummary> ASSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("asset").getter(PublishPackageVersionResponse.getter(PublishPackageVersionResponse::asset)).setter(PublishPackageVersionResponse.setter(Builder::asset)).constructor(AssetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, STATUS_FIELD, ASSET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PublishPackageVersionResponse.memberNameToFieldInitializer();
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final String version;
    private final String versionRevision;
    private final String status;
    private final AssetSummary asset;

    private PublishPackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.status = builder.status;
        this.asset = builder.asset;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String version() {
        return this.version;
    }

    public final String versionRevision() {
        return this.versionRevision;
    }

    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final AssetSummary asset() {
        return this.asset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.asset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishPackageVersionResponse)) {
            return false;
        }
        PublishPackageVersionResponse other = (PublishPackageVersionResponse)((Object)obj);
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionRevision(), other.versionRevision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.asset(), other.asset());
    }

    public final String toString() {
        return ToString.builder((String)"PublishPackageVersionResponse").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Version", (Object)this.version()).add("VersionRevision", (Object)this.versionRevision()).add("Status", (Object)this.statusAsString()).add("Asset", (Object)this.asset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "versionRevision": {
                return Optional.ofNullable(clazz.cast(this.versionRevision()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "asset": {
                return Optional.ofNullable(clazz.cast(this.asset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("format", FORMAT_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("package", PACKAGE_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("versionRevision", VERSION_REVISION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("asset", ASSET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishPackageVersionResponse, T> g) {
        return obj -> g.apply((PublishPackageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String packageValue;
        private String version;
        private String versionRevision;
        private String status;
        private AssetSummary asset;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishPackageVersionResponse model) {
            super(model);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.version(model.version);
            this.versionRevision(model.versionRevision);
            this.status(model.status);
            this.asset(model.asset);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVersionRevision() {
            return this.versionRevision;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        @Override
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final AssetSummary.Builder getAsset() {
            return this.asset != null ? this.asset.toBuilder() : null;
        }

        public final void setAsset(AssetSummary.BuilderImpl asset) {
            this.asset = asset != null ? asset.build() : null;
        }

        @Override
        public final Builder asset(AssetSummary asset) {
            this.asset = asset;
            return this;
        }

        @Override
        public PublishPackageVersionResponse build() {
            return new PublishPackageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PublishPackageVersionResponse> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder version(String var1);

        public Builder versionRevision(String var1);

        public Builder status(String var1);

        public Builder status(PackageVersionStatus var1);

        public Builder asset(AssetSummary var1);

        default public Builder asset(Consumer<AssetSummary.Builder> asset) {
            return this.asset((AssetSummary)((AssetSummary.Builder)AssetSummary.builder().applyMutation(asset)).build());
        }
    }
}

