/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeconnections.CodeConnectionsAsyncClient;
import software.amazon.awssdk.services.codeconnections.internal.UserAgentUtils;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksRequest;
import software.amazon.awssdk.services.codeconnections.model.ListRepositoryLinksResponse;

public class ListRepositoryLinksPublisher
implements SdkPublisher<ListRepositoryLinksResponse> {
    private final CodeConnectionsAsyncClient client;
    private final ListRepositoryLinksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRepositoryLinksPublisher(CodeConnectionsAsyncClient client, ListRepositoryLinksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRepositoryLinksPublisher(CodeConnectionsAsyncClient client, ListRepositoryLinksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRepositoryLinksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRepositoryLinksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRepositoryLinksResponseFetcher
    implements AsyncPageFetcher<ListRepositoryLinksResponse> {
        private ListRepositoryLinksResponseFetcher() {
        }

        public boolean hasNextPage(ListRepositoryLinksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRepositoryLinksResponse> nextPage(ListRepositoryLinksResponse previousPage) {
            if (previousPage == null) {
                return ListRepositoryLinksPublisher.this.client.listRepositoryLinks(ListRepositoryLinksPublisher.this.firstRequest);
            }
            return ListRepositoryLinksPublisher.this.client.listRepositoryLinks((ListRepositoryLinksRequest)((Object)ListRepositoryLinksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

