/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebhookFilterRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebhookFilterRule> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookFilterRule.getter(WebhookFilterRule::jsonPath)).setter(WebhookFilterRule.setter(Builder::jsonPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonPath").build()}).build();
    private static final SdkField<String> MATCH_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebhookFilterRule.getter(WebhookFilterRule::matchEquals)).setter(WebhookFilterRule.setter(Builder::matchEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchEquals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD, MATCH_EQUALS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jsonPath;
    private final String matchEquals;

    private WebhookFilterRule(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.matchEquals = builder.matchEquals;
    }

    public String jsonPath() {
        return this.jsonPath;
    }

    public String matchEquals() {
        return this.matchEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchEquals());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebhookFilterRule)) {
            return false;
        }
        WebhookFilterRule other = (WebhookFilterRule)obj;
        return Objects.equals(this.jsonPath(), other.jsonPath()) && Objects.equals(this.matchEquals(), other.matchEquals());
    }

    public String toString() {
        return ToString.builder((String)"WebhookFilterRule").add("JsonPath", (Object)this.jsonPath()).add("MatchEquals", (Object)this.matchEquals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jsonPath": {
                return Optional.ofNullable(clazz.cast(this.jsonPath()));
            }
            case "matchEquals": {
                return Optional.ofNullable(clazz.cast(this.matchEquals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebhookFilterRule, T> g) {
        return obj -> g.apply((WebhookFilterRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jsonPath;
        private String matchEquals;

        private BuilderImpl() {
        }

        private BuilderImpl(WebhookFilterRule model) {
            this.jsonPath(model.jsonPath);
            this.matchEquals(model.matchEquals);
        }

        public final String getJsonPath() {
            return this.jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public final String getMatchEquals() {
            return this.matchEquals;
        }

        @Override
        public final Builder matchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
            return this;
        }

        public final void setMatchEquals(String matchEquals) {
            this.matchEquals = matchEquals;
        }

        public WebhookFilterRule build() {
            return new WebhookFilterRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebhookFilterRule> {
        public Builder jsonPath(String var1);

        public Builder matchEquals(String var1);
    }
}

