/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codepipeline.CodePipelineAsyncClient;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsRequest;
import software.amazon.awssdk.services.codepipeline.model.ListPipelineExecutionsResponse;
import software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary;

public class ListPipelineExecutionsPublisher
implements SdkPublisher<ListPipelineExecutionsResponse> {
    private final CodePipelineAsyncClient client;
    private final ListPipelineExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineExecutionsPublisher(CodePipelineAsyncClient client, ListPipelineExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineExecutionsPublisher(CodePipelineAsyncClient client, ListPipelineExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineExecutionSummary> pipelineExecutionSummaries() {
        Function<ListPipelineExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineExecutionSummaries() != null) {
                return response.pipelineExecutionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineExecutionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineExecutionsResponseFetcher
    implements AsyncPageFetcher<ListPipelineExecutionsResponse> {
        private ListPipelineExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineExecutionsResponse> nextPage(ListPipelineExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineExecutionsPublisher.this.client.listPipelineExecutions(ListPipelineExecutionsPublisher.this.firstRequest);
            }
            return ListPipelineExecutionsPublisher.this.client.listPipelineExecutions((ListPipelineExecutionsRequest)((Object)ListPipelineExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

