/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management
 * Service (AWS KMS) key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionKey implements SdkPojo, Serializable, ToCopyableBuilder<EncryptionKey.Builder, EncryptionKey> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EncryptionKey::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(EncryptionKey::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private EncryptionKey(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
     * </p>
     * <note>
     * <p>
     * Aliases are recognized only in the account that created the customer master key (CMK). For cross-account actions,
     * you can only use the key ID or key ARN to identify the key.
     * </p>
     * </note>
     * 
     * @return The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias
     *         ARN.</p> <note>
     *         <p>
     *         Aliases are recognized only in the account that created the customer master key (CMK). For cross-account
     *         actions, you can only use the key ID or key ARN to identify the key.
     *         </p>
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a
     * pipeline, the value must be set to 'KMS'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or
     *         updating a pipeline, the value must be set to 'KMS'.
     * @see EncryptionKeyType
     */
    public final EncryptionKeyType type() {
        return EncryptionKeyType.fromValue(type);
    }

    /**
     * <p>
     * The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a
     * pipeline, the value must be set to 'KMS'.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or
     *         updating a pipeline, the value must be set to 'KMS'.
     * @see EncryptionKeyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey other = (EncryptionKey) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionKey").add("Id", id()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionKey, T> g) {
        return obj -> g.apply((EncryptionKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionKey> {
        /**
         * <p>
         * The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
         * </p>
         * <note>
         * <p>
         * Aliases are recognized only in the account that created the customer master key (CMK). For cross-account
         * actions, you can only use the key ID or key ARN to identify the key.
         * </p>
         * </note>
         * 
         * @param id
         *        The ID used to identify the key. For an AWS KMS key, you can use the key ID, the key ARN, or the alias
         *        ARN.</p> <note>
         *        <p>
         *        Aliases are recognized only in the account that created the customer master key (CMK). For
         *        cross-account actions, you can only use the key ID or key ARN to identify the key.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a
         * pipeline, the value must be set to 'KMS'.
         * </p>
         * 
         * @param type
         *        The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or
         *        updating a pipeline, the value must be set to 'KMS'.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or updating a
         * pipeline, the value must be set to 'KMS'.
         * </p>
         * 
         * @param type
         *        The type of encryption key, such as an AWS Key Management Service (AWS KMS) key. When creating or
         *        updating a pipeline, the value must be set to 'KMS'.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder type(EncryptionKeyType type);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionKey model) {
            id(model.id);
            type(model.type);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EncryptionKeyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public EncryptionKey build() {
            return new EncryptionKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
