/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codestar.model.CodeStarResponse;
import software.amazon.awssdk.services.codestar.model.UserProfileSummary;
import software.amazon.awssdk.services.codestar.model.UserProfilesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUserProfilesResponse
extends CodeStarResponse
implements ToCopyableBuilder<Builder, ListUserProfilesResponse> {
    private static final SdkField<List<UserProfileSummary>> USER_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userProfiles").getter(ListUserProfilesResponse.getter(ListUserProfilesResponse::userProfiles)).setter(ListUserProfilesResponse.setter(Builder::userProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUserProfilesResponse.getter(ListUserProfilesResponse::nextToken)).setter(ListUserProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private final List<UserProfileSummary> userProfiles;
    private final String nextToken;

    private ListUserProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.userProfiles = builder.userProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUserProfiles() {
        return this.userProfiles != null && !(this.userProfiles instanceof SdkAutoConstructList);
    }

    public final List<UserProfileSummary> userProfiles() {
        return this.userProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProfiles() ? this.userProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserProfilesResponse)) {
            return false;
        }
        ListUserProfilesResponse other = (ListUserProfilesResponse)((Object)obj);
        return this.hasUserProfiles() == other.hasUserProfiles() && Objects.equals(this.userProfiles(), other.userProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListUserProfilesResponse").add("UserProfiles", this.hasUserProfiles() ? this.userProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userProfiles": {
                return Optional.ofNullable(clazz.cast(this.userProfiles()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserProfilesResponse, T> g) {
        return obj -> g.apply((ListUserProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeStarResponse.BuilderImpl
    implements Builder {
        private List<UserProfileSummary> userProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserProfilesResponse model) {
            super(model);
            this.userProfiles(model.userProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<UserProfileSummary.Builder> getUserProfiles() {
            List<UserProfileSummary.Builder> result = UserProfilesListCopier.copyToBuilder(this.userProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProfiles(Collection<UserProfileSummary.BuilderImpl> userProfiles) {
            this.userProfiles = UserProfilesListCopier.copyFromBuilder(userProfiles);
        }

        @Override
        @Transient
        public final Builder userProfiles(Collection<UserProfileSummary> userProfiles) {
            this.userProfiles = UserProfilesListCopier.copy(userProfiles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userProfiles(UserProfileSummary ... userProfiles) {
            this.userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userProfiles(Consumer<UserProfileSummary.Builder> ... userProfiles) {
            this.userProfiles(Stream.of(userProfiles).map(c -> (UserProfileSummary)((UserProfileSummary.Builder)UserProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUserProfilesResponse build() {
            return new ListUserProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeStarResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUserProfilesResponse> {
        public Builder userProfiles(Collection<UserProfileSummary> var1);

        public Builder userProfiles(UserProfileSummary ... var1);

        public Builder userProfiles(Consumer<UserProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

