/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestar.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Location> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketName").getter(S3Location.getter(S3Location::bucketName)).setter(S3Location.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketName").build()}).build();
    private static final SdkField<String> BUCKET_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketKey").getter(S3Location.getter(S3Location::bucketKey)).setter(S3Location.setter(Builder::bucketKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, BUCKET_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String bucketKey;

    private S3Location(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketKey = builder.bucketKey;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketKey() {
        return this.bucketKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Location)) {
            return false;
        }
        S3Location other = (S3Location)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketKey(), other.bucketKey());
    }

    public final String toString() {
        return ToString.builder((String)"S3Location").add("BucketName", (Object)this.bucketName()).add("BucketKey", (Object)this.bucketKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "bucketKey": {
                return Optional.ofNullable(clazz.cast(this.bucketKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Location, T> g) {
        return obj -> g.apply((S3Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String bucketKey;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Location model) {
            this.bucketName(model.bucketName);
            this.bucketKey(model.bucketKey);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        @Transient
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketKey() {
            return this.bucketKey;
        }

        public final void setBucketKey(String bucketKey) {
            this.bucketKey = bucketKey;
        }

        @Override
        @Transient
        public final Builder bucketKey(String bucketKey) {
            this.bucketKey = bucketKey;
            return this;
        }

        public S3Location build() {
            return new S3Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Location> {
        public Builder bucketName(String var1);

        public Builder bucketKey(String var1);
    }
}

