/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceSyncStatus {
    FAILED("FAILED"),
    INITIATED("INITIATED"),
    IN_PROGRESS("IN_PROGRESS"),
    SUCCEEDED("SUCCEEDED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceSyncStatus> VALUE_MAP;
    private final String value;

    private ResourceSyncStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceSyncStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceSyncStatus> knownValues() {
        EnumSet<ResourceSyncStatus> knownValues = EnumSet.allOf(ResourceSyncStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceSyncStatus.class, ResourceSyncStatus::toString);
    }
}

