/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateType> {
    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SMSMessage").getter(MessageTemplateType.getter(MessageTemplateType::smsMessage)).setter(MessageTemplateType.setter(Builder::smsMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SMSMessage").build()}).build();
    private static final SdkField<String> EMAIL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailMessage").getter(MessageTemplateType.getter(MessageTemplateType::emailMessage)).setter(MessageTemplateType.setter(Builder::emailMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()}).build();
    private static final SdkField<String> EMAIL_SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailSubject").getter(MessageTemplateType.getter(MessageTemplateType::emailSubject)).setter(MessageTemplateType.setter(Builder::emailSubject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailSubject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MESSAGE_FIELD, EMAIL_MESSAGE_FIELD, EMAIL_SUBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String smsMessage;
    private final String emailMessage;
    private final String emailSubject;

    private MessageTemplateType(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
        this.emailMessage = builder.emailMessage;
        this.emailSubject = builder.emailSubject;
    }

    public final String smsMessage() {
        return this.smsMessage;
    }

    public final String emailMessage() {
        return this.emailMessage;
    }

    public final String emailSubject() {
        return this.emailSubject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smsMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailSubject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateType)) {
            return false;
        }
        MessageTemplateType other = (MessageTemplateType)obj;
        return Objects.equals(this.smsMessage(), other.smsMessage()) && Objects.equals(this.emailMessage(), other.emailMessage()) && Objects.equals(this.emailSubject(), other.emailSubject());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateType").add("SMSMessage", (Object)this.smsMessage()).add("EmailMessage", (Object)this.emailMessage()).add("EmailSubject", (Object)this.emailSubject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SMSMessage": {
                return Optional.ofNullable(clazz.cast(this.smsMessage()));
            }
            case "EmailMessage": {
                return Optional.ofNullable(clazz.cast(this.emailMessage()));
            }
            case "EmailSubject": {
                return Optional.ofNullable(clazz.cast(this.emailSubject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SMSMessage", SMS_MESSAGE_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("EmailSubject", EMAIL_SUBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateType, T> g) {
        return obj -> g.apply((MessageTemplateType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String smsMessage;
        private String emailMessage;
        private String emailSubject;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateType model) {
            this.smsMessage(model.smsMessage);
            this.emailMessage(model.emailMessage);
            this.emailSubject(model.emailSubject);
        }

        public final String getSmsMessage() {
            return this.smsMessage;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final String getEmailMessage() {
            return this.emailMessage;
        }

        public final void setEmailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
        }

        @Override
        public final Builder emailMessage(String emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final String getEmailSubject() {
            return this.emailSubject;
        }

        public final void setEmailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
        }

        @Override
        public final Builder emailSubject(String emailSubject) {
            this.emailSubject = emailSubject;
            return this;
        }

        public MessageTemplateType build() {
            return new MessageTemplateType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateType> {
        public Builder smsMessage(String var1);

        public Builder emailMessage(String var1);

        public Builder emailSubject(String var1);
    }
}

