/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.comprehend.model.BlockType;
import software.amazon.awssdk.services.comprehend.model.Geometry;
import software.amazon.awssdk.services.comprehend.model.ListOfRelationshipsCopier;
import software.amazon.awssdk.services.comprehend.model.RelationshipsListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Block
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Block> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Block.getter(Block::id)).setter(Block.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> BLOCK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlockType").getter(Block.getter(Block::blockTypeAsString)).setter(Block.setter(Builder::blockType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockType").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(Block.getter(Block::text)).setter(Block.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<Integer> PAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Page").getter(Block.getter(Block::page)).setter(Block.setter(Builder::page)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(Block.getter(Block::geometry)).setter(Block.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<List<RelationshipsListItem>> RELATIONSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Relationships").getter(Block.getter(Block::relationships)).setter(Block.setter(Builder::relationships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Relationships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationshipsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, BLOCK_TYPE_FIELD, TEXT_FIELD, PAGE_FIELD, GEOMETRY_FIELD, RELATIONSHIPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Block.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String blockType;
    private final String text;
    private final Integer page;
    private final Geometry geometry;
    private final List<RelationshipsListItem> relationships;

    private Block(BuilderImpl builder) {
        this.id = builder.id;
        this.blockType = builder.blockType;
        this.text = builder.text;
        this.page = builder.page;
        this.geometry = builder.geometry;
        this.relationships = builder.relationships;
    }

    public final String id() {
        return this.id;
    }

    public final BlockType blockType() {
        return BlockType.fromValue(this.blockType);
    }

    public final String blockTypeAsString() {
        return this.blockType;
    }

    public final String text() {
        return this.text;
    }

    public final Integer page() {
        return this.page;
    }

    public final Geometry geometry() {
        return this.geometry;
    }

    public final boolean hasRelationships() {
        return this.relationships != null && !(this.relationships instanceof SdkAutoConstructList);
    }

    public final List<RelationshipsListItem> relationships() {
        return this.relationships;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.page());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationships() ? this.relationships() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        Block other = (Block)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.blockTypeAsString(), other.blockTypeAsString()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.page(), other.page()) && Objects.equals(this.geometry(), other.geometry()) && this.hasRelationships() == other.hasRelationships() && Objects.equals(this.relationships(), other.relationships());
    }

    public final String toString() {
        return ToString.builder((String)"Block").add("Id", (Object)this.id()).add("BlockType", (Object)this.blockTypeAsString()).add("Text", (Object)this.text()).add("Page", (Object)this.page()).add("Geometry", (Object)this.geometry()).add("Relationships", this.hasRelationships() ? this.relationships() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "BlockType": {
                return Optional.ofNullable(clazz.cast(this.blockTypeAsString()));
            }
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Page": {
                return Optional.ofNullable(clazz.cast(this.page()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Relationships": {
                return Optional.ofNullable(clazz.cast(this.relationships()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("BlockType", BLOCK_TYPE_FIELD);
        map.put("Text", TEXT_FIELD);
        map.put("Page", PAGE_FIELD);
        map.put("Geometry", GEOMETRY_FIELD);
        map.put("Relationships", RELATIONSHIPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Block, T> g) {
        return obj -> g.apply((Block)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String blockType;
        private String text;
        private Integer page;
        private Geometry geometry;
        private List<RelationshipsListItem> relationships = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Block model) {
            this.id(model.id);
            this.blockType(model.blockType);
            this.text(model.text);
            this.page(model.page);
            this.geometry(model.geometry);
            this.relationships(model.relationships);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getBlockType() {
            return this.blockType;
        }

        public final void setBlockType(String blockType) {
            this.blockType = blockType;
        }

        @Override
        public final Builder blockType(String blockType) {
            this.blockType = blockType;
            return this;
        }

        @Override
        public final Builder blockType(BlockType blockType) {
            this.blockType(blockType == null ? null : blockType.toString());
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final Integer getPage() {
            return this.page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final List<RelationshipsListItem.Builder> getRelationships() {
            List<RelationshipsListItem.Builder> result = ListOfRelationshipsCopier.copyToBuilder(this.relationships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationships(Collection<RelationshipsListItem.BuilderImpl> relationships) {
            this.relationships = ListOfRelationshipsCopier.copyFromBuilder(relationships);
        }

        @Override
        public final Builder relationships(Collection<RelationshipsListItem> relationships) {
            this.relationships = ListOfRelationshipsCopier.copy(relationships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(RelationshipsListItem ... relationships) {
            this.relationships(Arrays.asList(relationships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationships(Consumer<RelationshipsListItem.Builder> ... relationships) {
            this.relationships(Stream.of(relationships).map(c -> (RelationshipsListItem)((RelationshipsListItem.Builder)RelationshipsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Block build() {
            return new Block(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Block> {
        public Builder id(String var1);

        public Builder blockType(String var1);

        public Builder blockType(BlockType var1);

        public Builder text(String var1);

        public Builder page(Integer var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }

        public Builder relationships(Collection<RelationshipsListItem> var1);

        public Builder relationships(RelationshipsListItem ... var1);

        public Builder relationships(Consumer<RelationshipsListItem.Builder> ... var1);
    }
}

