/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InvalidRequestDetailReason {
    DOCUMENT_SIZE_EXCEEDED("DOCUMENT_SIZE_EXCEEDED"),
    UNSUPPORTED_DOC_TYPE("UNSUPPORTED_DOC_TYPE"),
    PAGE_LIMIT_EXCEEDED("PAGE_LIMIT_EXCEEDED"),
    TEXTRACT_ACCESS_DENIED("TEXTRACT_ACCESS_DENIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InvalidRequestDetailReason> VALUE_MAP;
    private final String value;

    private InvalidRequestDetailReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InvalidRequestDetailReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InvalidRequestDetailReason> knownValues() {
        EnumSet<InvalidRequestDetailReason> knownValues = EnumSet.allOf(InvalidRequestDetailReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InvalidRequestDetailReason.class, InvalidRequestDetailReason::toString);
    }
}

