/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.comprehend.model.DocumentClassificationConfig;
import software.amazon.awssdk.services.comprehend.model.EntityRecognitionConfig;
import software.amazon.awssdk.services.comprehend.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskConfig> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(TaskConfig.getter(TaskConfig::languageCodeAsString)).setter(TaskConfig.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<DocumentClassificationConfig> DOCUMENT_CLASSIFICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentClassificationConfig").getter(TaskConfig.getter(TaskConfig::documentClassificationConfig)).setter(TaskConfig.setter(Builder::documentClassificationConfig)).constructor(DocumentClassificationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentClassificationConfig").build()}).build();
    private static final SdkField<EntityRecognitionConfig> ENTITY_RECOGNITION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EntityRecognitionConfig").getter(TaskConfig.getter(TaskConfig::entityRecognitionConfig)).setter(TaskConfig.setter(Builder::entityRecognitionConfig)).constructor(EntityRecognitionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityRecognitionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, DOCUMENT_CLASSIFICATION_CONFIG_FIELD, ENTITY_RECOGNITION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String languageCode;
    private final DocumentClassificationConfig documentClassificationConfig;
    private final EntityRecognitionConfig entityRecognitionConfig;

    private TaskConfig(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.documentClassificationConfig = builder.documentClassificationConfig;
        this.entityRecognitionConfig = builder.entityRecognitionConfig;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final DocumentClassificationConfig documentClassificationConfig() {
        return this.documentClassificationConfig;
    }

    public final EntityRecognitionConfig entityRecognitionConfig() {
        return this.entityRecognitionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentClassificationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRecognitionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskConfig)) {
            return false;
        }
        TaskConfig other = (TaskConfig)obj;
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.documentClassificationConfig(), other.documentClassificationConfig()) && Objects.equals(this.entityRecognitionConfig(), other.entityRecognitionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TaskConfig").add("LanguageCode", (Object)this.languageCodeAsString()).add("DocumentClassificationConfig", (Object)this.documentClassificationConfig()).add("EntityRecognitionConfig", (Object)this.entityRecognitionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "DocumentClassificationConfig": {
                return Optional.ofNullable(clazz.cast(this.documentClassificationConfig()));
            }
            case "EntityRecognitionConfig": {
                return Optional.ofNullable(clazz.cast(this.entityRecognitionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("DocumentClassificationConfig", DOCUMENT_CLASSIFICATION_CONFIG_FIELD);
        map.put("EntityRecognitionConfig", ENTITY_RECOGNITION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskConfig, T> g) {
        return obj -> g.apply((TaskConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private DocumentClassificationConfig documentClassificationConfig;
        private EntityRecognitionConfig entityRecognitionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskConfig model) {
            this.languageCode(model.languageCode);
            this.documentClassificationConfig(model.documentClassificationConfig);
            this.entityRecognitionConfig(model.entityRecognitionConfig);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final DocumentClassificationConfig.Builder getDocumentClassificationConfig() {
            return this.documentClassificationConfig != null ? this.documentClassificationConfig.toBuilder() : null;
        }

        public final void setDocumentClassificationConfig(DocumentClassificationConfig.BuilderImpl documentClassificationConfig) {
            this.documentClassificationConfig = documentClassificationConfig != null ? documentClassificationConfig.build() : null;
        }

        @Override
        public final Builder documentClassificationConfig(DocumentClassificationConfig documentClassificationConfig) {
            this.documentClassificationConfig = documentClassificationConfig;
            return this;
        }

        public final EntityRecognitionConfig.Builder getEntityRecognitionConfig() {
            return this.entityRecognitionConfig != null ? this.entityRecognitionConfig.toBuilder() : null;
        }

        public final void setEntityRecognitionConfig(EntityRecognitionConfig.BuilderImpl entityRecognitionConfig) {
            this.entityRecognitionConfig = entityRecognitionConfig != null ? entityRecognitionConfig.build() : null;
        }

        @Override
        public final Builder entityRecognitionConfig(EntityRecognitionConfig entityRecognitionConfig) {
            this.entityRecognitionConfig = entityRecognitionConfig;
            return this;
        }

        public TaskConfig build() {
            return new TaskConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskConfig> {
        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder documentClassificationConfig(DocumentClassificationConfig var1);

        default public Builder documentClassificationConfig(Consumer<DocumentClassificationConfig.Builder> documentClassificationConfig) {
            return this.documentClassificationConfig((DocumentClassificationConfig)((DocumentClassificationConfig.Builder)DocumentClassificationConfig.builder().applyMutation(documentClassificationConfig)).build());
        }

        public Builder entityRecognitionConfig(EntityRecognitionConfig var1);

        default public Builder entityRecognitionConfig(Consumer<EntityRecognitionConfig.Builder> entityRecognitionConfig) {
            return this.entityRecognitionConfig((EntityRecognitionConfig)((EntityRecognitionConfig.Builder)EntityRecognitionConfig.builder().applyMutation(entityRecognitionConfig)).build());
        }
    }
}

