/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomizableMetricThreshold {
    P90("P90"),
    P95("P95"),
    P99_5("P99_5"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomizableMetricThreshold> VALUE_MAP;
    private final String value;

    private CustomizableMetricThreshold(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomizableMetricThreshold fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomizableMetricThreshold> knownValues() {
        EnumSet<CustomizableMetricThreshold> knownValues = EnumSet.allOf(CustomizableMetricThreshold.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomizableMetricThreshold.class, CustomizableMetricThreshold::toString);
    }
}

