/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendation;
import software.amazon.awssdk.services.computeoptimizer.model.ContainerRecommendationsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.ECSSavingsOpportunityAfterDiscounts;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.ECSServiceProjectedUtilizationMetricsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.SavingsOpportunity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ECSServiceRecommendationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ECSServiceRecommendationOption> {
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::memory)).setter(ECSServiceRecommendationOption.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpu").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::cpu)).setter(ECSServiceRecommendationOption.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<SavingsOpportunity> SAVINGS_OPPORTUNITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunity").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::savingsOpportunity)).setter(ECSServiceRecommendationOption.setter(Builder::savingsOpportunity)).constructor(SavingsOpportunity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunity").build()}).build();
    private static final SdkField<ECSSavingsOpportunityAfterDiscounts> SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("savingsOpportunityAfterDiscounts").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::savingsOpportunityAfterDiscounts)).setter(ECSServiceRecommendationOption.setter(Builder::savingsOpportunityAfterDiscounts)).constructor(ECSSavingsOpportunityAfterDiscounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("savingsOpportunityAfterDiscounts").build()}).build();
    private static final SdkField<List<ECSServiceProjectedUtilizationMetric>> PROJECTED_UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectedUtilizationMetrics").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::projectedUtilizationMetrics)).setter(ECSServiceRecommendationOption.setter(Builder::projectedUtilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectedUtilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSServiceProjectedUtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContainerRecommendation>> CONTAINER_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containerRecommendations").getter(ECSServiceRecommendationOption.getter(ECSServiceRecommendationOption::containerRecommendations)).setter(ECSServiceRecommendationOption.setter(Builder::containerRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMORY_FIELD, CPU_FIELD, SAVINGS_OPPORTUNITY_FIELD, SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD, PROJECTED_UTILIZATION_METRICS_FIELD, CONTAINER_RECOMMENDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ECSServiceRecommendationOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer memory;
    private final Integer cpu;
    private final SavingsOpportunity savingsOpportunity;
    private final ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
    private final List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics;
    private final List<ContainerRecommendation> containerRecommendations;

    private ECSServiceRecommendationOption(BuilderImpl builder) {
        this.memory = builder.memory;
        this.cpu = builder.cpu;
        this.savingsOpportunity = builder.savingsOpportunity;
        this.savingsOpportunityAfterDiscounts = builder.savingsOpportunityAfterDiscounts;
        this.projectedUtilizationMetrics = builder.projectedUtilizationMetrics;
        this.containerRecommendations = builder.containerRecommendations;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final SavingsOpportunity savingsOpportunity() {
        return this.savingsOpportunity;
    }

    public final ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts() {
        return this.savingsOpportunityAfterDiscounts;
    }

    public final boolean hasProjectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics != null && !(this.projectedUtilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics() {
        return this.projectedUtilizationMetrics;
    }

    public final boolean hasContainerRecommendations() {
        return this.containerRecommendations != null && !(this.containerRecommendations instanceof SdkAutoConstructList);
    }

    public final List<ContainerRecommendation> containerRecommendations() {
        return this.containerRecommendations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunity());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsOpportunityAfterDiscounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerRecommendations() ? this.containerRecommendations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ECSServiceRecommendationOption)) {
            return false;
        }
        ECSServiceRecommendationOption other = (ECSServiceRecommendationOption)obj;
        return Objects.equals(this.memory(), other.memory()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.savingsOpportunity(), other.savingsOpportunity()) && Objects.equals(this.savingsOpportunityAfterDiscounts(), other.savingsOpportunityAfterDiscounts()) && this.hasProjectedUtilizationMetrics() == other.hasProjectedUtilizationMetrics() && Objects.equals(this.projectedUtilizationMetrics(), other.projectedUtilizationMetrics()) && this.hasContainerRecommendations() == other.hasContainerRecommendations() && Objects.equals(this.containerRecommendations(), other.containerRecommendations());
    }

    public final String toString() {
        return ToString.builder((String)"ECSServiceRecommendationOption").add("Memory", (Object)this.memory()).add("Cpu", (Object)this.cpu()).add("SavingsOpportunity", (Object)this.savingsOpportunity()).add("SavingsOpportunityAfterDiscounts", (Object)this.savingsOpportunityAfterDiscounts()).add("ProjectedUtilizationMetrics", this.hasProjectedUtilizationMetrics() ? this.projectedUtilizationMetrics() : null).add("ContainerRecommendations", this.hasContainerRecommendations() ? this.containerRecommendations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "savingsOpportunity": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunity()));
            }
            case "savingsOpportunityAfterDiscounts": {
                return Optional.ofNullable(clazz.cast(this.savingsOpportunityAfterDiscounts()));
            }
            case "projectedUtilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.projectedUtilizationMetrics()));
            }
            case "containerRecommendations": {
                return Optional.ofNullable(clazz.cast(this.containerRecommendations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memory", MEMORY_FIELD);
        map.put("cpu", CPU_FIELD);
        map.put("savingsOpportunity", SAVINGS_OPPORTUNITY_FIELD);
        map.put("savingsOpportunityAfterDiscounts", SAVINGS_OPPORTUNITY_AFTER_DISCOUNTS_FIELD);
        map.put("projectedUtilizationMetrics", PROJECTED_UTILIZATION_METRICS_FIELD);
        map.put("containerRecommendations", CONTAINER_RECOMMENDATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ECSServiceRecommendationOption, T> g) {
        return obj -> g.apply((ECSServiceRecommendationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer memory;
        private Integer cpu;
        private SavingsOpportunity savingsOpportunity;
        private ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts;
        private List<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private List<ContainerRecommendation> containerRecommendations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ECSServiceRecommendationOption model) {
            this.memory(model.memory);
            this.cpu(model.cpu);
            this.savingsOpportunity(model.savingsOpportunity);
            this.savingsOpportunityAfterDiscounts(model.savingsOpportunityAfterDiscounts);
            this.projectedUtilizationMetrics(model.projectedUtilizationMetrics);
            this.containerRecommendations(model.containerRecommendations);
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final SavingsOpportunity.Builder getSavingsOpportunity() {
            return this.savingsOpportunity != null ? this.savingsOpportunity.toBuilder() : null;
        }

        public final void setSavingsOpportunity(SavingsOpportunity.BuilderImpl savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity != null ? savingsOpportunity.build() : null;
        }

        @Override
        public final Builder savingsOpportunity(SavingsOpportunity savingsOpportunity) {
            this.savingsOpportunity = savingsOpportunity;
            return this;
        }

        public final ECSSavingsOpportunityAfterDiscounts.Builder getSavingsOpportunityAfterDiscounts() {
            return this.savingsOpportunityAfterDiscounts != null ? this.savingsOpportunityAfterDiscounts.toBuilder() : null;
        }

        public final void setSavingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts.BuilderImpl savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts != null ? savingsOpportunityAfterDiscounts.build() : null;
        }

        @Override
        public final Builder savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts savingsOpportunityAfterDiscounts) {
            this.savingsOpportunityAfterDiscounts = savingsOpportunityAfterDiscounts;
            return this;
        }

        public final List<ECSServiceProjectedUtilizationMetric.Builder> getProjectedUtilizationMetrics() {
            List<ECSServiceProjectedUtilizationMetric.Builder> result = ECSServiceProjectedUtilizationMetricsCopier.copyToBuilder(this.projectedUtilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectedUtilizationMetrics(Collection<ECSServiceProjectedUtilizationMetric.BuilderImpl> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ECSServiceProjectedUtilizationMetricsCopier.copyFromBuilder(projectedUtilizationMetrics);
        }

        @Override
        public final Builder projectedUtilizationMetrics(Collection<ECSServiceProjectedUtilizationMetric> projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics = ECSServiceProjectedUtilizationMetricsCopier.copy(projectedUtilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(ECSServiceProjectedUtilizationMetric ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Arrays.asList(projectedUtilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectedUtilizationMetrics(Consumer<ECSServiceProjectedUtilizationMetric.Builder> ... projectedUtilizationMetrics) {
            this.projectedUtilizationMetrics(Stream.of(projectedUtilizationMetrics).map(c -> (ECSServiceProjectedUtilizationMetric)((ECSServiceProjectedUtilizationMetric.Builder)ECSServiceProjectedUtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerRecommendation.Builder> getContainerRecommendations() {
            List<ContainerRecommendation.Builder> result = ContainerRecommendationsCopier.copyToBuilder(this.containerRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerRecommendations(Collection<ContainerRecommendation.BuilderImpl> containerRecommendations) {
            this.containerRecommendations = ContainerRecommendationsCopier.copyFromBuilder(containerRecommendations);
        }

        @Override
        public final Builder containerRecommendations(Collection<ContainerRecommendation> containerRecommendations) {
            this.containerRecommendations = ContainerRecommendationsCopier.copy(containerRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecommendations(ContainerRecommendation ... containerRecommendations) {
            this.containerRecommendations(Arrays.asList(containerRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerRecommendations(Consumer<ContainerRecommendation.Builder> ... containerRecommendations) {
            this.containerRecommendations(Stream.of(containerRecommendations).map(c -> (ContainerRecommendation)((ContainerRecommendation.Builder)ContainerRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ECSServiceRecommendationOption build() {
            return new ECSServiceRecommendationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ECSServiceRecommendationOption> {
        public Builder memory(Integer var1);

        public Builder cpu(Integer var1);

        public Builder savingsOpportunity(SavingsOpportunity var1);

        default public Builder savingsOpportunity(Consumer<SavingsOpportunity.Builder> savingsOpportunity) {
            return this.savingsOpportunity((SavingsOpportunity)((SavingsOpportunity.Builder)SavingsOpportunity.builder().applyMutation(savingsOpportunity)).build());
        }

        public Builder savingsOpportunityAfterDiscounts(ECSSavingsOpportunityAfterDiscounts var1);

        default public Builder savingsOpportunityAfterDiscounts(Consumer<ECSSavingsOpportunityAfterDiscounts.Builder> savingsOpportunityAfterDiscounts) {
            return this.savingsOpportunityAfterDiscounts((ECSSavingsOpportunityAfterDiscounts)((ECSSavingsOpportunityAfterDiscounts.Builder)ECSSavingsOpportunityAfterDiscounts.builder().applyMutation(savingsOpportunityAfterDiscounts)).build());
        }

        public Builder projectedUtilizationMetrics(Collection<ECSServiceProjectedUtilizationMetric> var1);

        public Builder projectedUtilizationMetrics(ECSServiceProjectedUtilizationMetric ... var1);

        public Builder projectedUtilizationMetrics(Consumer<ECSServiceProjectedUtilizationMetric.Builder> ... var1);

        public Builder containerRecommendations(Collection<ContainerRecommendation> var1);

        public Builder containerRecommendations(ContainerRecommendation ... var1);

        public Builder containerRecommendations(Consumer<ContainerRecommendation.Builder> ... var1);
    }
}

