/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.computeoptimizer.model.CurrentPerformanceRisk;
import software.amazon.awssdk.services.computeoptimizer.model.EffectiveRecommendationPreferences;
import software.amazon.awssdk.services.computeoptimizer.model.ExternalMetricStatus;
import software.amazon.awssdk.services.computeoptimizer.model.Finding;
import software.amazon.awssdk.services.computeoptimizer.model.GpuInfo;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadType;
import software.amazon.awssdk.services.computeoptimizer.model.InferredWorkloadTypesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceIdle;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCode;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationFindingReasonCodesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceRecommendationOption;
import software.amazon.awssdk.services.computeoptimizer.model.InstanceState;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationOptionsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSource;
import software.amazon.awssdk.services.computeoptimizer.model.RecommendationSourcesCopier;
import software.amazon.awssdk.services.computeoptimizer.model.Tag;
import software.amazon.awssdk.services.computeoptimizer.model.TagsCopier;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetric;
import software.amazon.awssdk.services.computeoptimizer.model.UtilizationMetricsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRecommendation> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(InstanceRecommendation.getter(InstanceRecommendation::instanceArn)).setter(InstanceRecommendation.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(InstanceRecommendation.getter(InstanceRecommendation::accountId)).setter(InstanceRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(InstanceRecommendation.getter(InstanceRecommendation::instanceName)).setter(InstanceRecommendation.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> CURRENT_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentInstanceType").getter(InstanceRecommendation.getter(InstanceRecommendation::currentInstanceType)).setter(InstanceRecommendation.setter(Builder::currentInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentInstanceType").build()}).build();
    private static final SdkField<String> FINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finding").getter(InstanceRecommendation.getter(InstanceRecommendation::findingAsString)).setter(InstanceRecommendation.setter(Builder::finding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finding").build()}).build();
    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("findingReasonCodes").getter(InstanceRecommendation.getter(InstanceRecommendation::findingReasonCodesAsStrings)).setter(InstanceRecommendation.setter(Builder::findingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UtilizationMetric>> UTILIZATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utilizationMetrics").getter(InstanceRecommendation.getter(InstanceRecommendation::utilizationMetrics)).setter(InstanceRecommendation.setter(Builder::utilizationMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utilizationMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> LOOK_BACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("lookBackPeriodInDays").getter(InstanceRecommendation.getter(InstanceRecommendation::lookBackPeriodInDays)).setter(InstanceRecommendation.setter(Builder::lookBackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookBackPeriodInDays").build()}).build();
    private static final SdkField<List<InstanceRecommendationOption>> RECOMMENDATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationOptions").getter(InstanceRecommendation.getter(InstanceRecommendation::recommendationOptions)).setter(InstanceRecommendation.setter(Builder::recommendationOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceRecommendationOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RecommendationSource>> RECOMMENDATION_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationSources").getter(InstanceRecommendation.getter(InstanceRecommendation::recommendationSources)).setter(InstanceRecommendation.setter(Builder::recommendationSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(InstanceRecommendation.getter(InstanceRecommendation::lastRefreshTimestamp)).setter(InstanceRecommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> CURRENT_PERFORMANCE_RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentPerformanceRisk").getter(InstanceRecommendation.getter(InstanceRecommendation::currentPerformanceRiskAsString)).setter(InstanceRecommendation.setter(Builder::currentPerformanceRisk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPerformanceRisk").build()}).build();
    private static final SdkField<EffectiveRecommendationPreferences> EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("effectiveRecommendationPreferences").getter(InstanceRecommendation.getter(InstanceRecommendation::effectiveRecommendationPreferences)).setter(InstanceRecommendation.setter(Builder::effectiveRecommendationPreferences)).constructor(EffectiveRecommendationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveRecommendationPreferences").build()}).build();
    private static final SdkField<List<String>> INFERRED_WORKLOAD_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferredWorkloadTypes").getter(InstanceRecommendation.getter(InstanceRecommendation::inferredWorkloadTypesAsStrings)).setter(InstanceRecommendation.setter(Builder::inferredWorkloadTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferredWorkloadTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceState").getter(InstanceRecommendation.getter(InstanceRecommendation::instanceStateAsString)).setter(InstanceRecommendation.setter(Builder::instanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceState").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(InstanceRecommendation.getter(InstanceRecommendation::tags)).setter(InstanceRecommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ExternalMetricStatus> EXTERNAL_METRIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalMetricStatus").getter(InstanceRecommendation.getter(InstanceRecommendation::externalMetricStatus)).setter(InstanceRecommendation.setter(Builder::externalMetricStatus)).constructor(ExternalMetricStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalMetricStatus").build()}).build();
    private static final SdkField<GpuInfo> CURRENT_INSTANCE_GPU_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentInstanceGpuInfo").getter(InstanceRecommendation.getter(InstanceRecommendation::currentInstanceGpuInfo)).setter(InstanceRecommendation.setter(Builder::currentInstanceGpuInfo)).constructor(GpuInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentInstanceGpuInfo").build()}).build();
    private static final SdkField<String> IDLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idle").getter(InstanceRecommendation.getter(InstanceRecommendation::idleAsString)).setter(InstanceRecommendation.setter(Builder::idle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idle").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, ACCOUNT_ID_FIELD, INSTANCE_NAME_FIELD, CURRENT_INSTANCE_TYPE_FIELD, FINDING_FIELD, FINDING_REASON_CODES_FIELD, UTILIZATION_METRICS_FIELD, LOOK_BACK_PERIOD_IN_DAYS_FIELD, RECOMMENDATION_OPTIONS_FIELD, RECOMMENDATION_SOURCES_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, CURRENT_PERFORMANCE_RISK_FIELD, EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD, INFERRED_WORKLOAD_TYPES_FIELD, INSTANCE_STATE_FIELD, TAGS_FIELD, EXTERNAL_METRIC_STATUS_FIELD, CURRENT_INSTANCE_GPU_INFO_FIELD, IDLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceArn;
    private final String accountId;
    private final String instanceName;
    private final String currentInstanceType;
    private final String finding;
    private final List<String> findingReasonCodes;
    private final List<UtilizationMetric> utilizationMetrics;
    private final Double lookBackPeriodInDays;
    private final List<InstanceRecommendationOption> recommendationOptions;
    private final List<RecommendationSource> recommendationSources;
    private final Instant lastRefreshTimestamp;
    private final String currentPerformanceRisk;
    private final EffectiveRecommendationPreferences effectiveRecommendationPreferences;
    private final List<String> inferredWorkloadTypes;
    private final String instanceState;
    private final List<Tag> tags;
    private final ExternalMetricStatus externalMetricStatus;
    private final GpuInfo currentInstanceGpuInfo;
    private final String idle;

    private InstanceRecommendation(BuilderImpl builder) {
        this.instanceArn = builder.instanceArn;
        this.accountId = builder.accountId;
        this.instanceName = builder.instanceName;
        this.currentInstanceType = builder.currentInstanceType;
        this.finding = builder.finding;
        this.findingReasonCodes = builder.findingReasonCodes;
        this.utilizationMetrics = builder.utilizationMetrics;
        this.lookBackPeriodInDays = builder.lookBackPeriodInDays;
        this.recommendationOptions = builder.recommendationOptions;
        this.recommendationSources = builder.recommendationSources;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.currentPerformanceRisk = builder.currentPerformanceRisk;
        this.effectiveRecommendationPreferences = builder.effectiveRecommendationPreferences;
        this.inferredWorkloadTypes = builder.inferredWorkloadTypes;
        this.instanceState = builder.instanceState;
        this.tags = builder.tags;
        this.externalMetricStatus = builder.externalMetricStatus;
        this.currentInstanceGpuInfo = builder.currentInstanceGpuInfo;
        this.idle = builder.idle;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final String currentInstanceType() {
        return this.currentInstanceType;
    }

    public final Finding finding() {
        return Finding.fromValue(this.finding);
    }

    public final String findingAsString() {
        return this.finding;
    }

    public final List<InstanceRecommendationFindingReasonCode> findingReasonCodes() {
        return InstanceRecommendationFindingReasonCodesCopier.copyStringToEnum(this.findingReasonCodes);
    }

    public final boolean hasFindingReasonCodes() {
        return this.findingReasonCodes != null && !(this.findingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> findingReasonCodesAsStrings() {
        return this.findingReasonCodes;
    }

    public final boolean hasUtilizationMetrics() {
        return this.utilizationMetrics != null && !(this.utilizationMetrics instanceof SdkAutoConstructList);
    }

    public final List<UtilizationMetric> utilizationMetrics() {
        return this.utilizationMetrics;
    }

    public final Double lookBackPeriodInDays() {
        return this.lookBackPeriodInDays;
    }

    public final boolean hasRecommendationOptions() {
        return this.recommendationOptions != null && !(this.recommendationOptions instanceof SdkAutoConstructList);
    }

    public final List<InstanceRecommendationOption> recommendationOptions() {
        return this.recommendationOptions;
    }

    public final boolean hasRecommendationSources() {
        return this.recommendationSources != null && !(this.recommendationSources instanceof SdkAutoConstructList);
    }

    public final List<RecommendationSource> recommendationSources() {
        return this.recommendationSources;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final CurrentPerformanceRisk currentPerformanceRisk() {
        return CurrentPerformanceRisk.fromValue(this.currentPerformanceRisk);
    }

    public final String currentPerformanceRiskAsString() {
        return this.currentPerformanceRisk;
    }

    public final EffectiveRecommendationPreferences effectiveRecommendationPreferences() {
        return this.effectiveRecommendationPreferences;
    }

    public final List<InferredWorkloadType> inferredWorkloadTypes() {
        return InferredWorkloadTypesCopier.copyStringToEnum(this.inferredWorkloadTypes);
    }

    public final boolean hasInferredWorkloadTypes() {
        return this.inferredWorkloadTypes != null && !(this.inferredWorkloadTypes instanceof SdkAutoConstructList);
    }

    public final List<String> inferredWorkloadTypesAsStrings() {
        return this.inferredWorkloadTypes;
    }

    public final InstanceState instanceState() {
        return InstanceState.fromValue(this.instanceState);
    }

    public final String instanceStateAsString() {
        return this.instanceState;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ExternalMetricStatus externalMetricStatus() {
        return this.externalMetricStatus;
    }

    public final GpuInfo currentInstanceGpuInfo() {
        return this.currentInstanceGpuInfo;
    }

    public final InstanceIdle idle() {
        return InstanceIdle.fromValue(this.idle);
    }

    public final String idleAsString() {
        return this.idle;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationMetrics() ? this.utilizationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lookBackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationOptions() ? this.recommendationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationSources() ? this.recommendationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPerformanceRiskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveRecommendationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.externalMetricStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstanceGpuInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRecommendation)) {
            return false;
        }
        InstanceRecommendation other = (InstanceRecommendation)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.currentInstanceType(), other.currentInstanceType()) && Objects.equals(this.findingAsString(), other.findingAsString()) && this.hasFindingReasonCodes() == other.hasFindingReasonCodes() && Objects.equals(this.findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings()) && this.hasUtilizationMetrics() == other.hasUtilizationMetrics() && Objects.equals(this.utilizationMetrics(), other.utilizationMetrics()) && Objects.equals(this.lookBackPeriodInDays(), other.lookBackPeriodInDays()) && this.hasRecommendationOptions() == other.hasRecommendationOptions() && Objects.equals(this.recommendationOptions(), other.recommendationOptions()) && this.hasRecommendationSources() == other.hasRecommendationSources() && Objects.equals(this.recommendationSources(), other.recommendationSources()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.currentPerformanceRiskAsString(), other.currentPerformanceRiskAsString()) && Objects.equals(this.effectiveRecommendationPreferences(), other.effectiveRecommendationPreferences()) && this.hasInferredWorkloadTypes() == other.hasInferredWorkloadTypes() && Objects.equals(this.inferredWorkloadTypesAsStrings(), other.inferredWorkloadTypesAsStrings()) && Objects.equals(this.instanceStateAsString(), other.instanceStateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.externalMetricStatus(), other.externalMetricStatus()) && Objects.equals(this.currentInstanceGpuInfo(), other.currentInstanceGpuInfo()) && Objects.equals(this.idleAsString(), other.idleAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRecommendation").add("InstanceArn", (Object)this.instanceArn()).add("AccountId", (Object)this.accountId()).add("InstanceName", (Object)this.instanceName()).add("CurrentInstanceType", (Object)this.currentInstanceType()).add("Finding", (Object)this.findingAsString()).add("FindingReasonCodes", this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null).add("UtilizationMetrics", this.hasUtilizationMetrics() ? this.utilizationMetrics() : null).add("LookBackPeriodInDays", (Object)this.lookBackPeriodInDays()).add("RecommendationOptions", this.hasRecommendationOptions() ? this.recommendationOptions() : null).add("RecommendationSources", this.hasRecommendationSources() ? this.recommendationSources() : null).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("CurrentPerformanceRisk", (Object)this.currentPerformanceRiskAsString()).add("EffectiveRecommendationPreferences", (Object)this.effectiveRecommendationPreferences()).add("InferredWorkloadTypes", this.hasInferredWorkloadTypes() ? this.inferredWorkloadTypesAsStrings() : null).add("InstanceState", (Object)this.instanceStateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ExternalMetricStatus", (Object)this.externalMetricStatus()).add("CurrentInstanceGpuInfo", (Object)this.currentInstanceGpuInfo()).add("Idle", (Object)this.idleAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "currentInstanceType": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceType()));
            }
            case "finding": {
                return Optional.ofNullable(clazz.cast(this.findingAsString()));
            }
            case "findingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.findingReasonCodesAsStrings()));
            }
            case "utilizationMetrics": {
                return Optional.ofNullable(clazz.cast(this.utilizationMetrics()));
            }
            case "lookBackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookBackPeriodInDays()));
            }
            case "recommendationOptions": {
                return Optional.ofNullable(clazz.cast(this.recommendationOptions()));
            }
            case "recommendationSources": {
                return Optional.ofNullable(clazz.cast(this.recommendationSources()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "currentPerformanceRisk": {
                return Optional.ofNullable(clazz.cast(this.currentPerformanceRiskAsString()));
            }
            case "effectiveRecommendationPreferences": {
                return Optional.ofNullable(clazz.cast(this.effectiveRecommendationPreferences()));
            }
            case "inferredWorkloadTypes": {
                return Optional.ofNullable(clazz.cast(this.inferredWorkloadTypesAsStrings()));
            }
            case "instanceState": {
                return Optional.ofNullable(clazz.cast(this.instanceStateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "externalMetricStatus": {
                return Optional.ofNullable(clazz.cast(this.externalMetricStatus()));
            }
            case "currentInstanceGpuInfo": {
                return Optional.ofNullable(clazz.cast(this.currentInstanceGpuInfo()));
            }
            case "idle": {
                return Optional.ofNullable(clazz.cast(this.idleAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("currentInstanceType", CURRENT_INSTANCE_TYPE_FIELD);
        map.put("finding", FINDING_FIELD);
        map.put("findingReasonCodes", FINDING_REASON_CODES_FIELD);
        map.put("utilizationMetrics", UTILIZATION_METRICS_FIELD);
        map.put("lookBackPeriodInDays", LOOK_BACK_PERIOD_IN_DAYS_FIELD);
        map.put("recommendationOptions", RECOMMENDATION_OPTIONS_FIELD);
        map.put("recommendationSources", RECOMMENDATION_SOURCES_FIELD);
        map.put("lastRefreshTimestamp", LAST_REFRESH_TIMESTAMP_FIELD);
        map.put("currentPerformanceRisk", CURRENT_PERFORMANCE_RISK_FIELD);
        map.put("effectiveRecommendationPreferences", EFFECTIVE_RECOMMENDATION_PREFERENCES_FIELD);
        map.put("inferredWorkloadTypes", INFERRED_WORKLOAD_TYPES_FIELD);
        map.put("instanceState", INSTANCE_STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("externalMetricStatus", EXTERNAL_METRIC_STATUS_FIELD);
        map.put("currentInstanceGpuInfo", CURRENT_INSTANCE_GPU_INFO_FIELD);
        map.put("idle", IDLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceRecommendation, T> g) {
        return obj -> g.apply((InstanceRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceArn;
        private String accountId;
        private String instanceName;
        private String currentInstanceType;
        private String finding;
        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();
        private List<UtilizationMetric> utilizationMetrics = DefaultSdkAutoConstructList.getInstance();
        private Double lookBackPeriodInDays;
        private List<InstanceRecommendationOption> recommendationOptions = DefaultSdkAutoConstructList.getInstance();
        private List<RecommendationSource> recommendationSources = DefaultSdkAutoConstructList.getInstance();
        private Instant lastRefreshTimestamp;
        private String currentPerformanceRisk;
        private EffectiveRecommendationPreferences effectiveRecommendationPreferences;
        private List<String> inferredWorkloadTypes = DefaultSdkAutoConstructList.getInstance();
        private String instanceState;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private ExternalMetricStatus externalMetricStatus;
        private GpuInfo currentInstanceGpuInfo;
        private String idle;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRecommendation model) {
            this.instanceArn(model.instanceArn);
            this.accountId(model.accountId);
            this.instanceName(model.instanceName);
            this.currentInstanceType(model.currentInstanceType);
            this.finding(model.finding);
            this.findingReasonCodesWithStrings(model.findingReasonCodes);
            this.utilizationMetrics(model.utilizationMetrics);
            this.lookBackPeriodInDays(model.lookBackPeriodInDays);
            this.recommendationOptions(model.recommendationOptions);
            this.recommendationSources(model.recommendationSources);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.currentPerformanceRisk(model.currentPerformanceRisk);
            this.effectiveRecommendationPreferences(model.effectiveRecommendationPreferences);
            this.inferredWorkloadTypesWithStrings(model.inferredWorkloadTypes);
            this.instanceState(model.instanceState);
            this.tags(model.tags);
            this.externalMetricStatus(model.externalMetricStatus);
            this.currentInstanceGpuInfo(model.currentInstanceGpuInfo);
            this.idle(model.idle);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getCurrentInstanceType() {
            return this.currentInstanceType;
        }

        public final void setCurrentInstanceType(String currentInstanceType) {
            this.currentInstanceType = currentInstanceType;
        }

        @Override
        public final Builder currentInstanceType(String currentInstanceType) {
            this.currentInstanceType = currentInstanceType;
            return this;
        }

        public final String getFinding() {
            return this.finding;
        }

        public final void setFinding(String finding) {
            this.finding = finding;
        }

        @Override
        public final Builder finding(String finding) {
            this.finding = finding;
            return this;
        }

        @Override
        public final Builder finding(Finding finding) {
            this.finding(finding == null ? null : finding.toString());
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (this.findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = InstanceRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = InstanceRecommendationFindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String ... findingReasonCodes) {
            this.findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public final Builder findingReasonCodes(Collection<InstanceRecommendationFindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = InstanceRecommendationFindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodes(InstanceRecommendationFindingReasonCode ... findingReasonCodes) {
            this.findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        public final List<UtilizationMetric.Builder> getUtilizationMetrics() {
            List<UtilizationMetric.Builder> result = UtilizationMetricsCopier.copyToBuilder(this.utilizationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtilizationMetrics(Collection<UtilizationMetric.BuilderImpl> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copyFromBuilder(utilizationMetrics);
        }

        @Override
        public final Builder utilizationMetrics(Collection<UtilizationMetric> utilizationMetrics) {
            this.utilizationMetrics = UtilizationMetricsCopier.copy(utilizationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(UtilizationMetric ... utilizationMetrics) {
            this.utilizationMetrics(Arrays.asList(utilizationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... utilizationMetrics) {
            this.utilizationMetrics(Stream.of(utilizationMetrics).map(c -> (UtilizationMetric)((UtilizationMetric.Builder)UtilizationMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getLookBackPeriodInDays() {
            return this.lookBackPeriodInDays;
        }

        public final void setLookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
        }

        @Override
        public final Builder lookBackPeriodInDays(Double lookBackPeriodInDays) {
            this.lookBackPeriodInDays = lookBackPeriodInDays;
            return this;
        }

        public final List<InstanceRecommendationOption.Builder> getRecommendationOptions() {
            List<InstanceRecommendationOption.Builder> result = RecommendationOptionsCopier.copyToBuilder(this.recommendationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationOptions(Collection<InstanceRecommendationOption.BuilderImpl> recommendationOptions) {
            this.recommendationOptions = RecommendationOptionsCopier.copyFromBuilder(recommendationOptions);
        }

        @Override
        public final Builder recommendationOptions(Collection<InstanceRecommendationOption> recommendationOptions) {
            this.recommendationOptions = RecommendationOptionsCopier.copy(recommendationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(InstanceRecommendationOption ... recommendationOptions) {
            this.recommendationOptions(Arrays.asList(recommendationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationOptions(Consumer<InstanceRecommendationOption.Builder> ... recommendationOptions) {
            this.recommendationOptions(Stream.of(recommendationOptions).map(c -> (InstanceRecommendationOption)((InstanceRecommendationOption.Builder)InstanceRecommendationOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RecommendationSource.Builder> getRecommendationSources() {
            List<RecommendationSource.Builder> result = RecommendationSourcesCopier.copyToBuilder(this.recommendationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationSources(Collection<RecommendationSource.BuilderImpl> recommendationSources) {
            this.recommendationSources = RecommendationSourcesCopier.copyFromBuilder(recommendationSources);
        }

        @Override
        public final Builder recommendationSources(Collection<RecommendationSource> recommendationSources) {
            this.recommendationSources = RecommendationSourcesCopier.copy(recommendationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSources(RecommendationSource ... recommendationSources) {
            this.recommendationSources(Arrays.asList(recommendationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationSources(Consumer<RecommendationSource.Builder> ... recommendationSources) {
            this.recommendationSources(Stream.of(recommendationSources).map(c -> (RecommendationSource)((RecommendationSource.Builder)RecommendationSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getCurrentPerformanceRisk() {
            return this.currentPerformanceRisk;
        }

        public final void setCurrentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
        }

        @Override
        public final Builder currentPerformanceRisk(String currentPerformanceRisk) {
            this.currentPerformanceRisk = currentPerformanceRisk;
            return this;
        }

        @Override
        public final Builder currentPerformanceRisk(CurrentPerformanceRisk currentPerformanceRisk) {
            this.currentPerformanceRisk(currentPerformanceRisk == null ? null : currentPerformanceRisk.toString());
            return this;
        }

        public final EffectiveRecommendationPreferences.Builder getEffectiveRecommendationPreferences() {
            return this.effectiveRecommendationPreferences != null ? this.effectiveRecommendationPreferences.toBuilder() : null;
        }

        public final void setEffectiveRecommendationPreferences(EffectiveRecommendationPreferences.BuilderImpl effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences != null ? effectiveRecommendationPreferences.build() : null;
        }

        @Override
        public final Builder effectiveRecommendationPreferences(EffectiveRecommendationPreferences effectiveRecommendationPreferences) {
            this.effectiveRecommendationPreferences = effectiveRecommendationPreferences;
            return this;
        }

        public final Collection<String> getInferredWorkloadTypes() {
            if (this.inferredWorkloadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inferredWorkloadTypes;
        }

        public final void setInferredWorkloadTypes(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
        }

        @Override
        public final Builder inferredWorkloadTypesWithStrings(Collection<String> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copy(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypesWithStrings(String ... inferredWorkloadTypes) {
            this.inferredWorkloadTypesWithStrings(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        @Override
        public final Builder inferredWorkloadTypes(Collection<InferredWorkloadType> inferredWorkloadTypes) {
            this.inferredWorkloadTypes = InferredWorkloadTypesCopier.copyEnumToString(inferredWorkloadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferredWorkloadTypes(InferredWorkloadType ... inferredWorkloadTypes) {
            this.inferredWorkloadTypes(Arrays.asList(inferredWorkloadTypes));
            return this;
        }

        public final String getInstanceState() {
            return this.instanceState;
        }

        public final void setInstanceState(String instanceState) {
            this.instanceState = instanceState;
        }

        @Override
        public final Builder instanceState(String instanceState) {
            this.instanceState = instanceState;
            return this;
        }

        @Override
        public final Builder instanceState(InstanceState instanceState) {
            this.instanceState(instanceState == null ? null : instanceState.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ExternalMetricStatus.Builder getExternalMetricStatus() {
            return this.externalMetricStatus != null ? this.externalMetricStatus.toBuilder() : null;
        }

        public final void setExternalMetricStatus(ExternalMetricStatus.BuilderImpl externalMetricStatus) {
            this.externalMetricStatus = externalMetricStatus != null ? externalMetricStatus.build() : null;
        }

        @Override
        public final Builder externalMetricStatus(ExternalMetricStatus externalMetricStatus) {
            this.externalMetricStatus = externalMetricStatus;
            return this;
        }

        public final GpuInfo.Builder getCurrentInstanceGpuInfo() {
            return this.currentInstanceGpuInfo != null ? this.currentInstanceGpuInfo.toBuilder() : null;
        }

        public final void setCurrentInstanceGpuInfo(GpuInfo.BuilderImpl currentInstanceGpuInfo) {
            this.currentInstanceGpuInfo = currentInstanceGpuInfo != null ? currentInstanceGpuInfo.build() : null;
        }

        @Override
        public final Builder currentInstanceGpuInfo(GpuInfo currentInstanceGpuInfo) {
            this.currentInstanceGpuInfo = currentInstanceGpuInfo;
            return this;
        }

        public final String getIdle() {
            return this.idle;
        }

        public final void setIdle(String idle) {
            this.idle = idle;
        }

        @Override
        public final Builder idle(String idle) {
            this.idle = idle;
            return this;
        }

        @Override
        public final Builder idle(InstanceIdle idle) {
            this.idle(idle == null ? null : idle.toString());
            return this;
        }

        public InstanceRecommendation build() {
            return new InstanceRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRecommendation> {
        public Builder instanceArn(String var1);

        public Builder accountId(String var1);

        public Builder instanceName(String var1);

        public Builder currentInstanceType(String var1);

        public Builder finding(String var1);

        public Builder finding(Finding var1);

        public Builder findingReasonCodesWithStrings(Collection<String> var1);

        public Builder findingReasonCodesWithStrings(String ... var1);

        public Builder findingReasonCodes(Collection<InstanceRecommendationFindingReasonCode> var1);

        public Builder findingReasonCodes(InstanceRecommendationFindingReasonCode ... var1);

        public Builder utilizationMetrics(Collection<UtilizationMetric> var1);

        public Builder utilizationMetrics(UtilizationMetric ... var1);

        public Builder utilizationMetrics(Consumer<UtilizationMetric.Builder> ... var1);

        public Builder lookBackPeriodInDays(Double var1);

        public Builder recommendationOptions(Collection<InstanceRecommendationOption> var1);

        public Builder recommendationOptions(InstanceRecommendationOption ... var1);

        public Builder recommendationOptions(Consumer<InstanceRecommendationOption.Builder> ... var1);

        public Builder recommendationSources(Collection<RecommendationSource> var1);

        public Builder recommendationSources(RecommendationSource ... var1);

        public Builder recommendationSources(Consumer<RecommendationSource.Builder> ... var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder currentPerformanceRisk(String var1);

        public Builder currentPerformanceRisk(CurrentPerformanceRisk var1);

        public Builder effectiveRecommendationPreferences(EffectiveRecommendationPreferences var1);

        default public Builder effectiveRecommendationPreferences(Consumer<EffectiveRecommendationPreferences.Builder> effectiveRecommendationPreferences) {
            return this.effectiveRecommendationPreferences((EffectiveRecommendationPreferences)((EffectiveRecommendationPreferences.Builder)EffectiveRecommendationPreferences.builder().applyMutation(effectiveRecommendationPreferences)).build());
        }

        public Builder inferredWorkloadTypesWithStrings(Collection<String> var1);

        public Builder inferredWorkloadTypesWithStrings(String ... var1);

        public Builder inferredWorkloadTypes(Collection<InferredWorkloadType> var1);

        public Builder inferredWorkloadTypes(InferredWorkloadType ... var1);

        public Builder instanceState(String var1);

        public Builder instanceState(InstanceState var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder externalMetricStatus(ExternalMetricStatus var1);

        default public Builder externalMetricStatus(Consumer<ExternalMetricStatus.Builder> externalMetricStatus) {
            return this.externalMetricStatus((ExternalMetricStatus)((ExternalMetricStatus.Builder)ExternalMetricStatus.builder().applyMutation(externalMetricStatus)).build());
        }

        public Builder currentInstanceGpuInfo(GpuInfo var1);

        default public Builder currentInstanceGpuInfo(Consumer<GpuInfo.Builder> currentInstanceGpuInfo) {
            return this.currentInstanceGpuInfo((GpuInfo)((GpuInfo.Builder)GpuInfo.builder().applyMutation(currentInstanceGpuInfo)).build());
        }

        public Builder idle(String var1);

        public Builder idle(InstanceIdle var1);
    }
}

