/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.computeoptimizer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RDSDBMetricStatistic {
    MAXIMUM("Maximum"),
    MINIMUM("Minimum"),
    AVERAGE("Average"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RDSDBMetricStatistic> VALUE_MAP;
    private final String value;

    private RDSDBMetricStatistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RDSDBMetricStatistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RDSDBMetricStatistic> knownValues() {
        EnumSet<RDSDBMetricStatistic> knownValues = EnumSet.allOf(RDSDBMetricStatistic.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RDSDBMetricStatistic.class, RDSDBMetricStatistic::toString);
    }
}

