/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.MemberAccountStatus;

public class GetOrganizationConfigRuleDetailedStatusPublisher
implements SdkPublisher<GetOrganizationConfigRuleDetailedStatusResponse> {
    private final ConfigAsyncClient client;
    private final GetOrganizationConfigRuleDetailedStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOrganizationConfigRuleDetailedStatusPublisher(ConfigAsyncClient client, GetOrganizationConfigRuleDetailedStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOrganizationConfigRuleDetailedStatusPublisher(ConfigAsyncClient client, GetOrganizationConfigRuleDetailedStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOrganizationConfigRuleDetailedStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOrganizationConfigRuleDetailedStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemberAccountStatus> organizationConfigRuleDetailedStatus() {
        Function<GetOrganizationConfigRuleDetailedStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConfigRuleDetailedStatus() != null) {
                return response.organizationConfigRuleDetailedStatus().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetOrganizationConfigRuleDetailedStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetOrganizationConfigRuleDetailedStatusResponseFetcher
    implements AsyncPageFetcher<GetOrganizationConfigRuleDetailedStatusResponse> {
        private GetOrganizationConfigRuleDetailedStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetOrganizationConfigRuleDetailedStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOrganizationConfigRuleDetailedStatusResponse> nextPage(GetOrganizationConfigRuleDetailedStatusResponse previousPage) {
            if (previousPage == null) {
                return GetOrganizationConfigRuleDetailedStatusPublisher.this.client.getOrganizationConfigRuleDetailedStatus(GetOrganizationConfigRuleDetailedStatusPublisher.this.firstRequest);
            }
            return GetOrganizationConfigRuleDetailedStatusPublisher.this.client.getOrganizationConfigRuleDetailedStatus((GetOrganizationConfigRuleDetailedStatusRequest)((Object)GetOrganizationConfigRuleDetailedStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

