/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.ContactState;
import software.amazon.awssdk.services.connect.model.QueueReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentContactReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentContactReference> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(AgentContactReference.getter(AgentContactReference::contactId)).setter(AgentContactReference.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()}).build();
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Channel").getter(AgentContactReference.getter(AgentContactReference::channelAsString)).setter(AgentContactReference.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channel").build()}).build();
    private static final SdkField<String> INITIATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiationMethod").getter(AgentContactReference.getter(AgentContactReference::initiationMethodAsString)).setter(AgentContactReference.setter(Builder::initiationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethod").build()}).build();
    private static final SdkField<String> AGENT_CONTACT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgentContactState").getter(AgentContactReference.getter(AgentContactReference::agentContactStateAsString)).setter(AgentContactReference.setter(Builder::agentContactState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentContactState").build()}).build();
    private static final SdkField<Instant> STATE_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateStartTimestamp").getter(AgentContactReference.getter(AgentContactReference::stateStartTimestamp)).setter(AgentContactReference.setter(Builder::stateStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateStartTimestamp").build()}).build();
    private static final SdkField<Instant> CONNECTED_TO_AGENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ConnectedToAgentTimestamp").getter(AgentContactReference.getter(AgentContactReference::connectedToAgentTimestamp)).setter(AgentContactReference.setter(Builder::connectedToAgentTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectedToAgentTimestamp").build()}).build();
    private static final SdkField<QueueReference> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Queue").getter(AgentContactReference.getter(AgentContactReference::queue)).setter(AgentContactReference.setter(Builder::queue)).constructor(QueueReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Queue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD, CHANNEL_FIELD, INITIATION_METHOD_FIELD, AGENT_CONTACT_STATE_FIELD, STATE_START_TIMESTAMP_FIELD, CONNECTED_TO_AGENT_TIMESTAMP_FIELD, QUEUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgentContactReference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactId;
    private final String channel;
    private final String initiationMethod;
    private final String agentContactState;
    private final Instant stateStartTimestamp;
    private final Instant connectedToAgentTimestamp;
    private final QueueReference queue;

    private AgentContactReference(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.channel = builder.channel;
        this.initiationMethod = builder.initiationMethod;
        this.agentContactState = builder.agentContactState;
        this.stateStartTimestamp = builder.stateStartTimestamp;
        this.connectedToAgentTimestamp = builder.connectedToAgentTimestamp;
        this.queue = builder.queue;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final Channel channel() {
        return Channel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final ContactInitiationMethod initiationMethod() {
        return ContactInitiationMethod.fromValue(this.initiationMethod);
    }

    public final String initiationMethodAsString() {
        return this.initiationMethod;
    }

    public final ContactState agentContactState() {
        return ContactState.fromValue(this.agentContactState);
    }

    public final String agentContactStateAsString() {
        return this.agentContactState;
    }

    public final Instant stateStartTimestamp() {
        return this.stateStartTimestamp;
    }

    public final Instant connectedToAgentTimestamp() {
        return this.connectedToAgentTimestamp;
    }

    public final QueueReference queue() {
        return this.queue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentContactStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedToAgentTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentContactReference)) {
            return false;
        }
        AgentContactReference other = (AgentContactReference)obj;
        return Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.initiationMethodAsString(), other.initiationMethodAsString()) && Objects.equals(this.agentContactStateAsString(), other.agentContactStateAsString()) && Objects.equals(this.stateStartTimestamp(), other.stateStartTimestamp()) && Objects.equals(this.connectedToAgentTimestamp(), other.connectedToAgentTimestamp()) && Objects.equals(this.queue(), other.queue());
    }

    public final String toString() {
        return ToString.builder((String)"AgentContactReference").add("ContactId", (Object)this.contactId()).add("Channel", (Object)this.channelAsString()).add("InitiationMethod", (Object)this.initiationMethodAsString()).add("AgentContactState", (Object)this.agentContactStateAsString()).add("StateStartTimestamp", (Object)this.stateStartTimestamp()).add("ConnectedToAgentTimestamp", (Object)this.connectedToAgentTimestamp()).add("Queue", (Object)this.queue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "Channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "InitiationMethod": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodAsString()));
            }
            case "AgentContactState": {
                return Optional.ofNullable(clazz.cast(this.agentContactStateAsString()));
            }
            case "StateStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.stateStartTimestamp()));
            }
            case "ConnectedToAgentTimestamp": {
                return Optional.ofNullable(clazz.cast(this.connectedToAgentTimestamp()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("Channel", CHANNEL_FIELD);
        map.put("InitiationMethod", INITIATION_METHOD_FIELD);
        map.put("AgentContactState", AGENT_CONTACT_STATE_FIELD);
        map.put("StateStartTimestamp", STATE_START_TIMESTAMP_FIELD);
        map.put("ConnectedToAgentTimestamp", CONNECTED_TO_AGENT_TIMESTAMP_FIELD);
        map.put("Queue", QUEUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentContactReference, T> g) {
        return obj -> g.apply((AgentContactReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactId;
        private String channel;
        private String initiationMethod;
        private String agentContactState;
        private Instant stateStartTimestamp;
        private Instant connectedToAgentTimestamp;
        private QueueReference queue;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentContactReference model) {
            this.contactId(model.contactId);
            this.channel(model.channel);
            this.initiationMethod(model.initiationMethod);
            this.agentContactState(model.agentContactState);
            this.stateStartTimestamp(model.stateStartTimestamp);
            this.connectedToAgentTimestamp(model.connectedToAgentTimestamp);
            this.queue(model.queue);
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getInitiationMethod() {
            return this.initiationMethod;
        }

        public final void setInitiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
        }

        @Override
        public final Builder initiationMethod(String initiationMethod) {
            this.initiationMethod = initiationMethod;
            return this;
        }

        @Override
        public final Builder initiationMethod(ContactInitiationMethod initiationMethod) {
            this.initiationMethod(initiationMethod == null ? null : initiationMethod.toString());
            return this;
        }

        public final String getAgentContactState() {
            return this.agentContactState;
        }

        public final void setAgentContactState(String agentContactState) {
            this.agentContactState = agentContactState;
        }

        @Override
        public final Builder agentContactState(String agentContactState) {
            this.agentContactState = agentContactState;
            return this;
        }

        @Override
        public final Builder agentContactState(ContactState agentContactState) {
            this.agentContactState(agentContactState == null ? null : agentContactState.toString());
            return this;
        }

        public final Instant getStateStartTimestamp() {
            return this.stateStartTimestamp;
        }

        public final void setStateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
        }

        @Override
        public final Builder stateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
            return this;
        }

        public final Instant getConnectedToAgentTimestamp() {
            return this.connectedToAgentTimestamp;
        }

        public final void setConnectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
        }

        @Override
        public final Builder connectedToAgentTimestamp(Instant connectedToAgentTimestamp) {
            this.connectedToAgentTimestamp = connectedToAgentTimestamp;
            return this;
        }

        public final QueueReference.Builder getQueue() {
            return this.queue != null ? this.queue.toBuilder() : null;
        }

        public final void setQueue(QueueReference.BuilderImpl queue) {
            this.queue = queue != null ? queue.build() : null;
        }

        @Override
        public final Builder queue(QueueReference queue) {
            this.queue = queue;
            return this;
        }

        public AgentContactReference build() {
            return new AgentContactReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentContactReference> {
        public Builder contactId(String var1);

        public Builder channel(String var1);

        public Builder channel(Channel var1);

        public Builder initiationMethod(String var1);

        public Builder initiationMethod(ContactInitiationMethod var1);

        public Builder agentContactState(String var1);

        public Builder agentContactState(ContactState var1);

        public Builder stateStartTimestamp(Instant var1);

        public Builder connectedToAgentTimestamp(Instant var1);

        public Builder queue(QueueReference var1);

        default public Builder queue(Consumer<QueueReference.Builder> queue) {
            return this.queue((QueueReference)((QueueReference.Builder)QueueReference.builder().applyMutation(queue)).build());
        }
    }
}

