/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateViewVersionRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, CreateViewVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateViewVersionRequest.getter(CreateViewVersionRequest::instanceId)).setter(CreateViewVersionRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewId").getter(CreateViewVersionRequest.getter(CreateViewVersionRequest::viewId)).setter(CreateViewVersionRequest.setter(Builder::viewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewId").build()}).build();
    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionDescription").getter(CreateViewVersionRequest.getter(CreateViewVersionRequest::versionDescription)).setter(CreateViewVersionRequest.setter(Builder::versionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build()}).build();
    private static final SdkField<String> VIEW_CONTENT_SHA256_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewContentSha256").getter(CreateViewVersionRequest.getter(CreateViewVersionRequest::viewContentSha256)).setter(CreateViewVersionRequest.setter(Builder::viewContentSha256)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewContentSha256").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, VIEW_ID_FIELD, VERSION_DESCRIPTION_FIELD, VIEW_CONTENT_SHA256_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateViewVersionRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String viewId;
    private final String versionDescription;
    private final String viewContentSha256;

    private CreateViewVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.viewId = builder.viewId;
        this.versionDescription = builder.versionDescription;
        this.viewContentSha256 = builder.viewContentSha256;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String viewId() {
        return this.viewId;
    }

    public final String versionDescription() {
        return this.versionDescription;
    }

    public final String viewContentSha256() {
        return this.viewContentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewContentSha256());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateViewVersionRequest)) {
            return false;
        }
        CreateViewVersionRequest other = (CreateViewVersionRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.viewId(), other.viewId()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.viewContentSha256(), other.viewContentSha256());
    }

    public final String toString() {
        return ToString.builder((String)"CreateViewVersionRequest").add("InstanceId", (Object)this.instanceId()).add("ViewId", (Object)this.viewId()).add("VersionDescription", (Object)this.versionDescription()).add("ViewContentSha256", (Object)this.viewContentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ViewId": {
                return Optional.ofNullable(clazz.cast(this.viewId()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "ViewContentSha256": {
                return Optional.ofNullable(clazz.cast(this.viewContentSha256()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ViewId", VIEW_ID_FIELD);
        map.put("VersionDescription", VERSION_DESCRIPTION_FIELD);
        map.put("ViewContentSha256", VIEW_CONTENT_SHA256_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateViewVersionRequest, T> g) {
        return obj -> g.apply((CreateViewVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String viewId;
        private String versionDescription;
        private String viewContentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateViewVersionRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.viewId(model.viewId);
            this.versionDescription(model.versionDescription);
            this.viewContentSha256(model.viewContentSha256);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getViewId() {
            return this.viewId;
        }

        public final void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public final Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getViewContentSha256() {
            return this.viewContentSha256;
        }

        public final void setViewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
        }

        @Override
        public final Builder viewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateViewVersionRequest build() {
            return new CreateViewVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateViewVersionRequest> {
        public Builder instanceId(String var1);

        public Builder viewId(String var1);

        public Builder versionDescription(String var1);

        public Builder viewContentSha256(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

