/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.ListPredefinedAttributesResponse;
import software.amazon.awssdk.services.connect.model.PredefinedAttributeSummary;

public class ListPredefinedAttributesPublisher
implements SdkPublisher<ListPredefinedAttributesResponse> {
    private final ConnectAsyncClient client;
    private final ListPredefinedAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPredefinedAttributesPublisher(ConnectAsyncClient client, ListPredefinedAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPredefinedAttributesPublisher(ConnectAsyncClient client, ListPredefinedAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPredefinedAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPredefinedAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PredefinedAttributeSummary> predefinedAttributeSummaryList() {
        Function<ListPredefinedAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.predefinedAttributeSummaryList() != null) {
                return response.predefinedAttributeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPredefinedAttributesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPredefinedAttributesResponseFetcher
    implements AsyncPageFetcher<ListPredefinedAttributesResponse> {
        private ListPredefinedAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListPredefinedAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPredefinedAttributesResponse> nextPage(ListPredefinedAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListPredefinedAttributesPublisher.this.client.listPredefinedAttributes(ListPredefinedAttributesPublisher.this.firstRequest);
            }
            return ListPredefinedAttributesPublisher.this.client.listPredefinedAttributes((ListPredefinedAttributesRequest)((Object)ListPredefinedAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

