/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.PredefinedAttribute;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesRequest;
import software.amazon.awssdk.services.connect.model.SearchPredefinedAttributesResponse;

public class SearchPredefinedAttributesIterable
implements SdkIterable<SearchPredefinedAttributesResponse> {
    private final ConnectClient client;
    private final SearchPredefinedAttributesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchPredefinedAttributesIterable(ConnectClient client, SearchPredefinedAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchPredefinedAttributesResponseFetcher();
    }

    public Iterator<SearchPredefinedAttributesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PredefinedAttribute> predefinedAttributes() {
        Function<SearchPredefinedAttributesResponse, Iterator> getIterator = response -> {
            if (response != null && response.predefinedAttributes() != null) {
                return response.predefinedAttributes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchPredefinedAttributesResponseFetcher
    implements SyncPageFetcher<SearchPredefinedAttributesResponse> {
        private SearchPredefinedAttributesResponseFetcher() {
        }

        public boolean hasNextPage(SearchPredefinedAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchPredefinedAttributesResponse nextPage(SearchPredefinedAttributesResponse previousPage) {
            if (previousPage == null) {
                return SearchPredefinedAttributesIterable.this.client.searchPredefinedAttributes(SearchPredefinedAttributesIterable.this.firstRequest);
            }
            return SearchPredefinedAttributesIterable.this.client.searchPredefinedAttributes((SearchPredefinedAttributesRequest)((Object)SearchPredefinedAttributesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

