/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsRequest;
import software.amazon.awssdk.services.connectcampaigns.model.GetCampaignStateBatchRequestCampaignIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCampaignStateBatchRequest
extends ConnectCampaignsRequest
implements ToCopyableBuilder<Builder, GetCampaignStateBatchRequest> {
    private static final SdkField<List<String>> CAMPAIGN_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("campaignIds").getter(GetCampaignStateBatchRequest.getter(GetCampaignStateBatchRequest::campaignIds)).setter(GetCampaignStateBatchRequest.setter(Builder::campaignIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCampaignStateBatchRequest.memberNameToFieldInitializer();
    private final List<String> campaignIds;

    private GetCampaignStateBatchRequest(BuilderImpl builder) {
        super(builder);
        this.campaignIds = builder.campaignIds;
    }

    public final boolean hasCampaignIds() {
        return this.campaignIds != null && !(this.campaignIds instanceof SdkAutoConstructList);
    }

    public final List<String> campaignIds() {
        return this.campaignIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCampaignIds() ? this.campaignIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignStateBatchRequest)) {
            return false;
        }
        GetCampaignStateBatchRequest other = (GetCampaignStateBatchRequest)((Object)obj);
        return this.hasCampaignIds() == other.hasCampaignIds() && Objects.equals(this.campaignIds(), other.campaignIds());
    }

    public final String toString() {
        return ToString.builder((String)"GetCampaignStateBatchRequest").add("CampaignIds", this.hasCampaignIds() ? this.campaignIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignIds": {
                return Optional.ofNullable(clazz.cast(this.campaignIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("campaignIds", CAMPAIGN_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignStateBatchRequest, T> g) {
        return obj -> g.apply((GetCampaignStateBatchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsRequest.BuilderImpl
    implements Builder {
        private List<String> campaignIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignStateBatchRequest model) {
            super(model);
            this.campaignIds(model.campaignIds);
        }

        public final Collection<String> getCampaignIds() {
            if (this.campaignIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.campaignIds;
        }

        public final void setCampaignIds(Collection<String> campaignIds) {
            this.campaignIds = GetCampaignStateBatchRequestCampaignIdsListCopier.copy(campaignIds);
        }

        @Override
        public final Builder campaignIds(Collection<String> campaignIds) {
            this.campaignIds = GetCampaignStateBatchRequestCampaignIdsListCopier.copy(campaignIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder campaignIds(String ... campaignIds) {
            this.campaignIds(Arrays.asList(campaignIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCampaignStateBatchRequest build() {
            return new GetCampaignStateBatchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCampaignsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCampaignStateBatchRequest> {
        public Builder campaignIds(Collection<String> var1);

        public Builder campaignIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

