/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRightsizingRecommendationRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetRightsizingRecommendationRequest> {
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetRightsizingRecommendationRequest.getter(GetRightsizingRecommendationRequest::filter)).setter(GetRightsizingRecommendationRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<RightsizingRecommendationConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(GetRightsizingRecommendationRequest.getter(GetRightsizingRecommendationRequest::configuration)).setter(GetRightsizingRecommendationRequest.setter(Builder::configuration)).constructor(RightsizingRecommendationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(GetRightsizingRecommendationRequest.getter(GetRightsizingRecommendationRequest::service)).setter(GetRightsizingRecommendationRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(GetRightsizingRecommendationRequest.getter(GetRightsizingRecommendationRequest::pageSize)).setter(GetRightsizingRecommendationRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetRightsizingRecommendationRequest.getter(GetRightsizingRecommendationRequest::nextPageToken)).setter(GetRightsizingRecommendationRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, CONFIGURATION_FIELD, SERVICE_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRightsizingRecommendationRequest.memberNameToFieldInitializer();
    private final Expression filter;
    private final RightsizingRecommendationConfiguration configuration;
    private final String service;
    private final Integer pageSize;
    private final String nextPageToken;

    private GetRightsizingRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.configuration = builder.configuration;
        this.service = builder.service;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final RightsizingRecommendationConfiguration configuration() {
        return this.configuration;
    }

    public final String service() {
        return this.service;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRightsizingRecommendationRequest)) {
            return false;
        }
        GetRightsizingRecommendationRequest other = (GetRightsizingRecommendationRequest)((Object)obj);
        return Objects.equals(this.filter(), other.filter()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.service(), other.service()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetRightsizingRecommendationRequest").add("Filter", (Object)this.filter()).add("Configuration", (Object)this.configuration()).add("Service", (Object)this.service()).add("PageSize", (Object)this.pageSize()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filter", FILTER_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRightsizingRecommendationRequest, T> g) {
        return obj -> g.apply((GetRightsizingRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private Expression filter;
        private RightsizingRecommendationConfiguration configuration;
        private String service;
        private Integer pageSize;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRightsizingRecommendationRequest model) {
            super(model);
            this.filter(model.filter);
            this.configuration(model.configuration);
            this.service(model.service);
            this.pageSize(model.pageSize);
            this.nextPageToken(model.nextPageToken);
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final RightsizingRecommendationConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RightsizingRecommendationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RightsizingRecommendationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRightsizingRecommendationRequest build() {
            return new GetRightsizingRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRightsizingRecommendationRequest> {
        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder configuration(RightsizingRecommendationConfiguration var1);

        default public Builder configuration(Consumer<RightsizingRecommendationConfiguration.Builder> configuration) {
            return this.configuration((RightsizingRecommendationConfiguration)((RightsizingRecommendationConfiguration.Builder)RightsizingRecommendationConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder service(String var1);

        public Builder pageSize(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

