/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataType;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansDataTypesCopier;
import software.amazon.awssdk.services.costexplorer.model.SortDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSavingsPlansUtilizationDetailsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::timePeriod)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::filter)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataType").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::dataTypeAsStrings)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::dataTypeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::nextToken)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::maxResults)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortBy").getter(GetSavingsPlansUtilizationDetailsRequest.getter(GetSavingsPlansUtilizationDetailsRequest::sortBy)).setter(GetSavingsPlansUtilizationDetailsRequest.setter(Builder::sortBy)).constructor(SortDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, FILTER_FIELD, DATA_TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, SORT_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSavingsPlansUtilizationDetailsRequest.memberNameToFieldInitializer();
    private final DateInterval timePeriod;
    private final Expression filter;
    private final List<String> dataType;
    private final String nextToken;
    private final Integer maxResults;
    private final SortDefinition sortBy;

    private GetSavingsPlansUtilizationDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.filter = builder.filter;
        this.dataType = builder.dataType;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.sortBy = builder.sortBy;
    }

    public final DateInterval timePeriod() {
        return this.timePeriod;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final List<SavingsPlansDataType> dataType() {
        return SavingsPlansDataTypesCopier.copyStringToEnum(this.dataType);
    }

    public final boolean hasDataType() {
        return this.dataType != null && !(this.dataType instanceof SdkAutoConstructList);
    }

    public final List<String> dataTypeAsStrings() {
        return this.dataType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final SortDefinition sortBy() {
        return this.sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataType() ? this.dataTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationDetailsRequest)) {
            return false;
        }
        GetSavingsPlansUtilizationDetailsRequest other = (GetSavingsPlansUtilizationDetailsRequest)((Object)obj);
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.filter(), other.filter()) && this.hasDataType() == other.hasDataType() && Objects.equals(this.dataTypeAsStrings(), other.dataTypeAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.sortBy(), other.sortBy());
    }

    public final String toString() {
        return ToString.builder((String)"GetSavingsPlansUtilizationDetailsRequest").add("TimePeriod", (Object)this.timePeriod()).add("Filter", (Object)this.filter()).add("DataType", this.hasDataType() ? this.dataTypeAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("SortBy", (Object)this.sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("DataType", DATA_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationDetailsRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private Expression filter;
        private List<String> dataType = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private SortDefinition sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationDetailsRequest model) {
            super(model);
            this.timePeriod(model.timePeriod);
            this.filter(model.filter);
            this.dataTypeWithStrings(model.dataType);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.sortBy(model.sortBy);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getDataType() {
            if (this.dataType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataType;
        }

        public final void setDataType(Collection<String> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copy(dataType);
        }

        @Override
        public final Builder dataTypeWithStrings(Collection<String> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copy(dataType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataTypeWithStrings(String ... dataType) {
            this.dataTypeWithStrings(Arrays.asList(dataType));
            return this;
        }

        @Override
        public final Builder dataType(Collection<SavingsPlansDataType> dataType) {
            this.dataType = SavingsPlansDataTypesCopier.copyEnumToString(dataType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataType(SavingsPlansDataType ... dataType) {
            this.dataType(Arrays.asList(dataType));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final SortDefinition.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansUtilizationDetailsRequest build() {
            return new GetSavingsPlansUtilizationDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsRequest> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder dataTypeWithStrings(Collection<String> var1);

        public Builder dataTypeWithStrings(String ... var1);

        public Builder dataType(Collection<SavingsPlansDataType> var1);

        public Builder dataType(SavingsPlansDataType ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder sortBy(SortDefinition var1);

        default public Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return this.sortBy((SortDefinition)((SortDefinition.Builder)SortDefinition.builder().applyMutation(sortBy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

