/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileError;
import software.amazon.awssdk.services.customerprofiles.model.BatchGetProfileErrorListCopier;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.Profile;
import software.amazon.awssdk.services.customerprofiles.model.ProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetProfileResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, BatchGetProfileResponse> {
    private static final SdkField<List<BatchGetProfileError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchGetProfileResponse.getter(BatchGetProfileResponse::errors)).setter(BatchGetProfileResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetProfileError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Profile>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(BatchGetProfileResponse.getter(BatchGetProfileResponse::profiles)).setter(BatchGetProfileResponse.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Profile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, PROFILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetProfileResponse.memberNameToFieldInitializer();
    private final List<BatchGetProfileError> errors;
    private final List<Profile> profiles;

    private BatchGetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.profiles = builder.profiles;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetProfileError> errors() {
        return this.errors;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<Profile> profiles() {
        return this.profiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProfileResponse)) {
            return false;
        }
        BatchGetProfileResponse other = (BatchGetProfileResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetProfileResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("Profiles", this.hasProfiles() ? this.profiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Errors", ERRORS_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetProfileResponse, T> g) {
        return obj -> g.apply((BatchGetProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<BatchGetProfileError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<Profile> profiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProfileResponse model) {
            super(model);
            this.errors(model.errors);
            this.profiles(model.profiles);
        }

        public final List<BatchGetProfileError.Builder> getErrors() {
            List<BatchGetProfileError.Builder> result = BatchGetProfileErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetProfileError.BuilderImpl> errors) {
            this.errors = BatchGetProfileErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetProfileError> errors) {
            this.errors = BatchGetProfileErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetProfileError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetProfileError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetProfileError)((BatchGetProfileError.Builder)BatchGetProfileError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Profile.Builder> getProfiles() {
            List<Profile.Builder> result = ProfileListCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<Profile.BuilderImpl> profiles) {
            this.profiles = ProfileListCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<Profile> profiles) {
            this.profiles = ProfileListCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Profile ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<Profile.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (Profile)((Profile.Builder)Profile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetProfileResponse build() {
            return new BatchGetProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetProfileResponse> {
        public Builder errors(Collection<BatchGetProfileError> var1);

        public Builder errors(BatchGetProfileError ... var1);

        public Builder errors(Consumer<BatchGetProfileError.Builder> ... var1);

        public Builder profiles(Collection<Profile> var1);

        public Builder profiles(Profile ... var1);

        public Builder profiles(Consumer<Profile.Builder> ... var1);
    }
}

