/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.IdentityResolutionJob;
import software.amazon.awssdk.services.customerprofiles.model.IdentityResolutionJobsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIdentityResolutionJobsResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListIdentityResolutionJobsResponse> {
    private static final SdkField<List<IdentityResolutionJob>> IDENTITY_RESOLUTION_JOBS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityResolutionJobsList").getter(ListIdentityResolutionJobsResponse.getter(ListIdentityResolutionJobsResponse::identityResolutionJobsList)).setter(ListIdentityResolutionJobsResponse.setter(Builder::identityResolutionJobsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityResolutionJobsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityResolutionJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIdentityResolutionJobsResponse.getter(ListIdentityResolutionJobsResponse::nextToken)).setter(ListIdentityResolutionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_RESOLUTION_JOBS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIdentityResolutionJobsResponse.memberNameToFieldInitializer();
    private final List<IdentityResolutionJob> identityResolutionJobsList;
    private final String nextToken;

    private ListIdentityResolutionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.identityResolutionJobsList = builder.identityResolutionJobsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasIdentityResolutionJobsList() {
        return this.identityResolutionJobsList != null && !(this.identityResolutionJobsList instanceof SdkAutoConstructList);
    }

    public final List<IdentityResolutionJob> identityResolutionJobsList() {
        return this.identityResolutionJobsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityResolutionJobsList() ? this.identityResolutionJobsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityResolutionJobsResponse)) {
            return false;
        }
        ListIdentityResolutionJobsResponse other = (ListIdentityResolutionJobsResponse)((Object)obj);
        return this.hasIdentityResolutionJobsList() == other.hasIdentityResolutionJobsList() && Objects.equals(this.identityResolutionJobsList(), other.identityResolutionJobsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListIdentityResolutionJobsResponse").add("IdentityResolutionJobsList", this.hasIdentityResolutionJobsList() ? this.identityResolutionJobsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityResolutionJobsList": {
                return Optional.ofNullable(clazz.cast(this.identityResolutionJobsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdentityResolutionJobsList", IDENTITY_RESOLUTION_JOBS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityResolutionJobsResponse, T> g) {
        return obj -> g.apply((ListIdentityResolutionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<IdentityResolutionJob> identityResolutionJobsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityResolutionJobsResponse model) {
            super(model);
            this.identityResolutionJobsList(model.identityResolutionJobsList);
            this.nextToken(model.nextToken);
        }

        public final List<IdentityResolutionJob.Builder> getIdentityResolutionJobsList() {
            List<IdentityResolutionJob.Builder> result = IdentityResolutionJobsListCopier.copyToBuilder(this.identityResolutionJobsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityResolutionJobsList(Collection<IdentityResolutionJob.BuilderImpl> identityResolutionJobsList) {
            this.identityResolutionJobsList = IdentityResolutionJobsListCopier.copyFromBuilder(identityResolutionJobsList);
        }

        @Override
        public final Builder identityResolutionJobsList(Collection<IdentityResolutionJob> identityResolutionJobsList) {
            this.identityResolutionJobsList = IdentityResolutionJobsListCopier.copy(identityResolutionJobsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityResolutionJobsList(IdentityResolutionJob ... identityResolutionJobsList) {
            this.identityResolutionJobsList(Arrays.asList(identityResolutionJobsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityResolutionJobsList(Consumer<IdentityResolutionJob.Builder> ... identityResolutionJobsList) {
            this.identityResolutionJobsList(Stream.of(identityResolutionJobsList).map(c -> (IdentityResolutionJob)((IdentityResolutionJob.Builder)IdentityResolutionJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityResolutionJobsResponse build() {
            return new ListIdentityResolutionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIdentityResolutionJobsResponse> {
        public Builder identityResolutionJobsList(Collection<IdentityResolutionJob> var1);

        public Builder identityResolutionJobsList(IdentityResolutionJob ... var1);

        public Builder identityResolutionJobsList(Consumer<IdentityResolutionJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

