/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesResponse;

public class GetSimilarProfilesIterable
implements SdkIterable<GetSimilarProfilesResponse> {
    private final CustomerProfilesClient client;
    private final GetSimilarProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSimilarProfilesIterable(CustomerProfilesClient client, GetSimilarProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSimilarProfilesResponseFetcher();
    }

    public Iterator<GetSimilarProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> profileIds() {
        Function<GetSimilarProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileIds() != null) {
                return response.profileIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetSimilarProfilesResponseFetcher
    implements SyncPageFetcher<GetSimilarProfilesResponse> {
        private GetSimilarProfilesResponseFetcher() {
        }

        public boolean hasNextPage(GetSimilarProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSimilarProfilesResponse nextPage(GetSimilarProfilesResponse previousPage) {
            if (previousPage == null) {
                return GetSimilarProfilesIterable.this.client.getSimilarProfiles(GetSimilarProfilesIterable.this.firstRequest);
            }
            return GetSimilarProfilesIterable.this.client.getSimilarProfiles((GetSimilarProfilesRequest)((Object)GetSimilarProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

