/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComputeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComputeConfig> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(ComputeConfig.getter(ComputeConfig::availabilityZone)).setter(ComputeConfig.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> DNS_NAME_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsNameServers").getter(ComputeConfig.getter(ComputeConfig::dnsNameServers)).setter(ComputeConfig.setter(Builder::dnsNameServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsNameServers").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ComputeConfig.getter(ComputeConfig::kmsKeyId)).setter(ComputeConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacityUnits").getter(ComputeConfig.getter(ComputeConfig::maxCapacityUnits)).setter(ComputeConfig.setter(Builder::maxCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacityUnits").build()}).build();
    private static final SdkField<Integer> MIN_CAPACITY_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacityUnits").getter(ComputeConfig.getter(ComputeConfig::minCapacityUnits)).setter(ComputeConfig.setter(Builder::minCapacityUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacityUnits").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(ComputeConfig.getter(ComputeConfig::multiAZ)).setter(ComputeConfig.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ComputeConfig.getter(ComputeConfig::preferredMaintenanceWindow)).setter(ComputeConfig.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> REPLICATION_SUBNET_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSubnetGroupId").getter(ComputeConfig.getter(ComputeConfig::replicationSubnetGroupId)).setter(ComputeConfig.setter(Builder::replicationSubnetGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroupId").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(ComputeConfig.getter(ComputeConfig::vpcSecurityGroupIds)).setter(ComputeConfig.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, DNS_NAME_SERVERS_FIELD, KMS_KEY_ID_FIELD, MAX_CAPACITY_UNITS_FIELD, MIN_CAPACITY_UNITS_FIELD, MULTI_AZ_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SUBNET_GROUP_ID_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComputeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final String dnsNameServers;
    private final String kmsKeyId;
    private final Integer maxCapacityUnits;
    private final Integer minCapacityUnits;
    private final Boolean multiAZ;
    private final String preferredMaintenanceWindow;
    private final String replicationSubnetGroupId;
    private final List<String> vpcSecurityGroupIds;

    private ComputeConfig(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.dnsNameServers = builder.dnsNameServers;
        this.kmsKeyId = builder.kmsKeyId;
        this.maxCapacityUnits = builder.maxCapacityUnits;
        this.minCapacityUnits = builder.minCapacityUnits;
        this.multiAZ = builder.multiAZ;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSubnetGroupId = builder.replicationSubnetGroupId;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String dnsNameServers() {
        return this.dnsNameServers;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Integer maxCapacityUnits() {
        return this.maxCapacityUnits;
    }

    public final Integer minCapacityUnits() {
        return this.minCapacityUnits;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String replicationSubnetGroupId() {
        return this.replicationSubnetGroupId;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsNameServers());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSubnetGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeConfig)) {
            return false;
        }
        ComputeConfig other = (ComputeConfig)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dnsNameServers(), other.dnsNameServers()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.maxCapacityUnits(), other.maxCapacityUnits()) && Objects.equals(this.minCapacityUnits(), other.minCapacityUnits()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSubnetGroupId(), other.replicationSubnetGroupId()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"ComputeConfig").add("AvailabilityZone", (Object)this.availabilityZone()).add("DnsNameServers", (Object)this.dnsNameServers()).add("KmsKeyId", (Object)this.kmsKeyId()).add("MaxCapacityUnits", (Object)this.maxCapacityUnits()).add("MinCapacityUnits", (Object)this.minCapacityUnits()).add("MultiAZ", (Object)this.multiAZ()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSubnetGroupId", (Object)this.replicationSubnetGroupId()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DnsNameServers": {
                return Optional.ofNullable(clazz.cast(this.dnsNameServers()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "MaxCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.maxCapacityUnits()));
            }
            case "MinCapacityUnits": {
                return Optional.ofNullable(clazz.cast(this.minCapacityUnits()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSubnetGroupId": {
                return Optional.ofNullable(clazz.cast(this.replicationSubnetGroupId()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DnsNameServers", DNS_NAME_SERVERS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("MaxCapacityUnits", MAX_CAPACITY_UNITS_FIELD);
        map.put("MinCapacityUnits", MIN_CAPACITY_UNITS_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("ReplicationSubnetGroupId", REPLICATION_SUBNET_GROUP_ID_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeConfig, T> g) {
        return obj -> g.apply((ComputeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private String dnsNameServers;
        private String kmsKeyId;
        private Integer maxCapacityUnits;
        private Integer minCapacityUnits;
        private Boolean multiAZ;
        private String preferredMaintenanceWindow;
        private String replicationSubnetGroupId;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeConfig model) {
            this.availabilityZone(model.availabilityZone);
            this.dnsNameServers(model.dnsNameServers);
            this.kmsKeyId(model.kmsKeyId);
            this.maxCapacityUnits(model.maxCapacityUnits);
            this.minCapacityUnits(model.minCapacityUnits);
            this.multiAZ(model.multiAZ);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSubnetGroupId(model.replicationSubnetGroupId);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDnsNameServers() {
            return this.dnsNameServers;
        }

        public final void setDnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
        }

        @Override
        public final Builder dnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getMaxCapacityUnits() {
            return this.maxCapacityUnits;
        }

        public final void setMaxCapacityUnits(Integer maxCapacityUnits) {
            this.maxCapacityUnits = maxCapacityUnits;
        }

        @Override
        public final Builder maxCapacityUnits(Integer maxCapacityUnits) {
            this.maxCapacityUnits = maxCapacityUnits;
            return this;
        }

        public final Integer getMinCapacityUnits() {
            return this.minCapacityUnits;
        }

        public final void setMinCapacityUnits(Integer minCapacityUnits) {
            this.minCapacityUnits = minCapacityUnits;
        }

        @Override
        public final Builder minCapacityUnits(Integer minCapacityUnits) {
            this.minCapacityUnits = minCapacityUnits;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSubnetGroupId() {
            return this.replicationSubnetGroupId;
        }

        public final void setReplicationSubnetGroupId(String replicationSubnetGroupId) {
            this.replicationSubnetGroupId = replicationSubnetGroupId;
        }

        @Override
        public final Builder replicationSubnetGroupId(String replicationSubnetGroupId) {
            this.replicationSubnetGroupId = replicationSubnetGroupId;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public ComputeConfig build() {
            return new ComputeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComputeConfig> {
        public Builder availabilityZone(String var1);

        public Builder dnsNameServers(String var1);

        public Builder kmsKeyId(String var1);

        public Builder maxCapacityUnits(Integer var1);

        public Builder minCapacityUnits(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSubnetGroupId(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);
    }
}

