/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimestreamSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimestreamSettings> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(TimestreamSettings.getter(TimestreamSettings::databaseName)).setter(TimestreamSettings.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<Integer> MEMORY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemoryDuration").getter(TimestreamSettings.getter(TimestreamSettings::memoryDuration)).setter(TimestreamSettings.setter(Builder::memoryDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryDuration").build()}).build();
    private static final SdkField<Integer> MAGNETIC_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MagneticDuration").getter(TimestreamSettings.getter(TimestreamSettings::magneticDuration)).setter(TimestreamSettings.setter(Builder::magneticDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticDuration").build()}).build();
    private static final SdkField<Boolean> CDC_INSERTS_AND_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CdcInsertsAndUpdates").getter(TimestreamSettings.getter(TimestreamSettings::cdcInsertsAndUpdates)).setter(TimestreamSettings.setter(Builder::cdcInsertsAndUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcInsertsAndUpdates").build()}).build();
    private static final SdkField<Boolean> ENABLE_MAGNETIC_STORE_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableMagneticStoreWrites").getter(TimestreamSettings.getter(TimestreamSettings::enableMagneticStoreWrites)).setter(TimestreamSettings.setter(Builder::enableMagneticStoreWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableMagneticStoreWrites").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, MEMORY_DURATION_FIELD, MAGNETIC_DURATION_FIELD, CDC_INSERTS_AND_UPDATES_FIELD, ENABLE_MAGNETIC_STORE_WRITES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TimestreamSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final Integer memoryDuration;
    private final Integer magneticDuration;
    private final Boolean cdcInsertsAndUpdates;
    private final Boolean enableMagneticStoreWrites;

    private TimestreamSettings(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.memoryDuration = builder.memoryDuration;
        this.magneticDuration = builder.magneticDuration;
        this.cdcInsertsAndUpdates = builder.cdcInsertsAndUpdates;
        this.enableMagneticStoreWrites = builder.enableMagneticStoreWrites;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Integer memoryDuration() {
        return this.memoryDuration;
    }

    public final Integer magneticDuration() {
        return this.magneticDuration;
    }

    public final Boolean cdcInsertsAndUpdates() {
        return this.cdcInsertsAndUpdates;
    }

    public final Boolean enableMagneticStoreWrites() {
        return this.enableMagneticStoreWrites;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.magneticDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcInsertsAndUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableMagneticStoreWrites());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamSettings)) {
            return false;
        }
        TimestreamSettings other = (TimestreamSettings)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.memoryDuration(), other.memoryDuration()) && Objects.equals(this.magneticDuration(), other.magneticDuration()) && Objects.equals(this.cdcInsertsAndUpdates(), other.cdcInsertsAndUpdates()) && Objects.equals(this.enableMagneticStoreWrites(), other.enableMagneticStoreWrites());
    }

    public final String toString() {
        return ToString.builder((String)"TimestreamSettings").add("DatabaseName", (Object)this.databaseName()).add("MemoryDuration", (Object)this.memoryDuration()).add("MagneticDuration", (Object)this.magneticDuration()).add("CdcInsertsAndUpdates", (Object)this.cdcInsertsAndUpdates()).add("EnableMagneticStoreWrites", (Object)this.enableMagneticStoreWrites()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "MemoryDuration": {
                return Optional.ofNullable(clazz.cast(this.memoryDuration()));
            }
            case "MagneticDuration": {
                return Optional.ofNullable(clazz.cast(this.magneticDuration()));
            }
            case "CdcInsertsAndUpdates": {
                return Optional.ofNullable(clazz.cast(this.cdcInsertsAndUpdates()));
            }
            case "EnableMagneticStoreWrites": {
                return Optional.ofNullable(clazz.cast(this.enableMagneticStoreWrites()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("MemoryDuration", MEMORY_DURATION_FIELD);
        map.put("MagneticDuration", MAGNETIC_DURATION_FIELD);
        map.put("CdcInsertsAndUpdates", CDC_INSERTS_AND_UPDATES_FIELD);
        map.put("EnableMagneticStoreWrites", ENABLE_MAGNETIC_STORE_WRITES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimestreamSettings, T> g) {
        return obj -> g.apply((TimestreamSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private Integer memoryDuration;
        private Integer magneticDuration;
        private Boolean cdcInsertsAndUpdates;
        private Boolean enableMagneticStoreWrites;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamSettings model) {
            this.databaseName(model.databaseName);
            this.memoryDuration(model.memoryDuration);
            this.magneticDuration(model.magneticDuration);
            this.cdcInsertsAndUpdates(model.cdcInsertsAndUpdates);
            this.enableMagneticStoreWrites(model.enableMagneticStoreWrites);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Integer getMemoryDuration() {
            return this.memoryDuration;
        }

        public final void setMemoryDuration(Integer memoryDuration) {
            this.memoryDuration = memoryDuration;
        }

        @Override
        public final Builder memoryDuration(Integer memoryDuration) {
            this.memoryDuration = memoryDuration;
            return this;
        }

        public final Integer getMagneticDuration() {
            return this.magneticDuration;
        }

        public final void setMagneticDuration(Integer magneticDuration) {
            this.magneticDuration = magneticDuration;
        }

        @Override
        public final Builder magneticDuration(Integer magneticDuration) {
            this.magneticDuration = magneticDuration;
            return this;
        }

        public final Boolean getCdcInsertsAndUpdates() {
            return this.cdcInsertsAndUpdates;
        }

        public final void setCdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
        }

        @Override
        public final Builder cdcInsertsAndUpdates(Boolean cdcInsertsAndUpdates) {
            this.cdcInsertsAndUpdates = cdcInsertsAndUpdates;
            return this;
        }

        public final Boolean getEnableMagneticStoreWrites() {
            return this.enableMagneticStoreWrites;
        }

        public final void setEnableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
        }

        @Override
        public final Builder enableMagneticStoreWrites(Boolean enableMagneticStoreWrites) {
            this.enableMagneticStoreWrites = enableMagneticStoreWrites;
            return this;
        }

        public TimestreamSettings build() {
            return new TimestreamSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimestreamSettings> {
        public Builder databaseName(String var1);

        public Builder memoryDuration(Integer var1);

        public Builder magneticDuration(Integer var1);

        public Builder cdcInsertsAndUpdates(Boolean var1);

        public Builder enableMagneticStoreWrites(Boolean var1);
    }
}

