/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CreateLocationNfsRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLocationNfsRequest extends DataSyncRequest implements
        ToCopyableBuilder<CreateLocationNfsRequest.Builder, CreateLocationNfsRequest> {
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationNfsRequest::subdirectory)).setter(setter(Builder::subdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()).build();

    private static final SdkField<String> SERVER_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateLocationNfsRequest::serverHostname)).setter(setter(Builder::serverHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerHostname").build()).build();

    private static final SdkField<OnPremConfig> ON_PREM_CONFIG_FIELD = SdkField.<OnPremConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateLocationNfsRequest::onPremConfig)).setter(setter(Builder::onPremConfig))
            .constructor(OnPremConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremConfig").build()).build();

    private static final SdkField<NfsMountOptions> MOUNT_OPTIONS_FIELD = SdkField
            .<NfsMountOptions> builder(MarshallingType.SDK_POJO).getter(getter(CreateLocationNfsRequest::mountOptions))
            .setter(setter(Builder::mountOptions)).constructor(NfsMountOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountOptions").build()).build();

    private static final SdkField<List<TagListEntry>> TAGS_FIELD = SdkField
            .<List<TagListEntry>> builder(MarshallingType.LIST)
            .getter(getter(CreateLocationNfsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagListEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagListEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBDIRECTORY_FIELD,
            SERVER_HOSTNAME_FIELD, ON_PREM_CONFIG_FIELD, MOUNT_OPTIONS_FIELD, TAGS_FIELD));

    private final String subdirectory;

    private final String serverHostname;

    private final OnPremConfig onPremConfig;

    private final NfsMountOptions mountOptions;

    private final List<TagListEntry> tags;

    private CreateLocationNfsRequest(BuilderImpl builder) {
        super(builder);
        this.subdirectory = builder.subdirectory;
        this.serverHostname = builder.serverHostname;
        this.onPremConfig = builder.onPremConfig;
        this.mountOptions = builder.mountOptions;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data to
     * the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of that
     * path. The path should be such that it can be mounted by other NFS clients in your network.
     * </p>
     * <p>
     * To see all the paths exported by your NFS server. run "<code>showmount -e nfs-server-name</code>" from an NFS
     * client that has access to your server. You can specify any directory that appears in the results, and any
     * subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
     * </p>
     * <p>
     * To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the data. To
     * ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that the permissions for
     * all of the files that you want DataSync allow read access for all users. Doing either enables the agent to read
     * the files. For the agent to access directories, you must additionally enable all execute access.
     * </p>
     * <p>
     * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat
     * Enterprise Linux documentation.
     * </p>
     * 
     * @return The subdirectory in the NFS file system that is used to read data from the NFS source location or write
     *         data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a
     *         subdirectory of that path. The path should be such that it can be mounted by other NFS clients in your
     *         network. </p>
     *         <p>
     *         To see all the paths exported by your NFS server. run "<code>showmount -e nfs-server-name</code>" from an
     *         NFS client that has access to your server. You can specify any directory that appears in the results, and
     *         any subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos
     *         authentication.
     *         </p>
     *         <p>
     *         To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the
     *         data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that
     *         the permissions for all of the files that you want DataSync allow read access for all users. Doing either
     *         enables the agent to read the files. For the agent to access directories, you must additionally enable
     *         all execute access.
     *         </p>
     *         <p>
     *         For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red
     *         Hat Enterprise Linux documentation.
     */
    public String subdirectory() {
        return subdirectory;
    }

    /**
     * <p>
     * The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server. An
     * agent that is installed on-premises uses this host name to mount the NFS server in a network.
     * </p>
     * <note>
     * <p>
     * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
     * </p>
     * </note>
     * 
     * @return The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS
     *         server. An agent that is installed on-premises uses this host name to mount the NFS server in a network.
     *         </p> <note>
     *         <p>
     *         This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
     *         </p>
     */
    public String serverHostname() {
        return serverHostname;
    }

    /**
     * <p>
     * Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
     * </p>
     * 
     * @return Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
     */
    public OnPremConfig onPremConfig() {
        return onPremConfig;
    }

    /**
     * <p>
     * The NFS mount options that DataSync can use to mount your NFS share.
     * </p>
     * 
     * @return The NFS mount options that DataSync can use to mount your NFS share.
     */
    public NfsMountOptions mountOptions() {
        return mountOptions;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
     * string. We recommend using tags to name your resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The key-value pair that represents the tag that you want to add to the location. The value can be an
     *         empty string. We recommend using tags to name your resources.
     */
    public List<TagListEntry> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(serverHostname());
        hashCode = 31 * hashCode + Objects.hashCode(onPremConfig());
        hashCode = 31 * hashCode + Objects.hashCode(mountOptions());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLocationNfsRequest)) {
            return false;
        }
        CreateLocationNfsRequest other = (CreateLocationNfsRequest) obj;
        return Objects.equals(subdirectory(), other.subdirectory()) && Objects.equals(serverHostname(), other.serverHostname())
                && Objects.equals(onPremConfig(), other.onPremConfig()) && Objects.equals(mountOptions(), other.mountOptions())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLocationNfsRequest").add("Subdirectory", subdirectory())
                .add("ServerHostname", serverHostname()).add("OnPremConfig", onPremConfig()).add("MountOptions", mountOptions())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subdirectory":
            return Optional.ofNullable(clazz.cast(subdirectory()));
        case "ServerHostname":
            return Optional.ofNullable(clazz.cast(serverHostname()));
        case "OnPremConfig":
            return Optional.ofNullable(clazz.cast(onPremConfig()));
        case "MountOptions":
            return Optional.ofNullable(clazz.cast(mountOptions()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLocationNfsRequest, T> g) {
        return obj -> g.apply((CreateLocationNfsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DataSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLocationNfsRequest> {
        /**
         * <p>
         * The subdirectory in the NFS file system that is used to read data from the NFS source location or write data
         * to the NFS destination. The NFS path should be a path that's exported by the NFS server, or a subdirectory of
         * that path. The path should be such that it can be mounted by other NFS clients in your network.
         * </p>
         * <p>
         * To see all the paths exported by your NFS server. run "<code>showmount -e nfs-server-name</code>" from an NFS
         * client that has access to your server. You can specify any directory that appears in the results, and any
         * subdirectory of that directory. Ensure that the NFS export is accessible without Kerberos authentication.
         * </p>
         * <p>
         * To transfer all the data in the folder you specified, DataSync needs to have permissions to read all the
         * data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure that the
         * permissions for all of the files that you want DataSync allow read access for all users. Doing either enables
         * the agent to read the files. For the agent to access directories, you must additionally enable all execute
         * access.
         * </p>
         * <p>
         * For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the Red Hat
         * Enterprise Linux documentation.
         * </p>
         * 
         * @param subdirectory
         *        The subdirectory in the NFS file system that is used to read data from the NFS source location or
         *        write data to the NFS destination. The NFS path should be a path that's exported by the NFS server, or
         *        a subdirectory of that path. The path should be such that it can be mounted by other NFS clients in
         *        your network. </p>
         *        <p>
         *        To see all the paths exported by your NFS server. run "<code>showmount -e nfs-server-name</code>" from
         *        an NFS client that has access to your server. You can specify any directory that appears in the
         *        results, and any subdirectory of that directory. Ensure that the NFS export is accessible without
         *        Kerberos authentication.
         *        </p>
         *        <p>
         *        To transfer all the data in the folder you specified, DataSync needs to have permissions to read all
         *        the data. To ensure this, either configure the NFS export with <code>no_root_squash,</code> or ensure
         *        that the permissions for all of the files that you want DataSync allow read access for all users.
         *        Doing either enables the agent to read the files. For the agent to access directories, you must
         *        additionally enable all execute access.
         *        </p>
         *        <p>
         *        For information about NFS export configuration, see 18.7. The /etc/exports Configuration File in the
         *        Red Hat Enterprise Linux documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subdirectory(String subdirectory);

        /**
         * <p>
         * The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS server.
         * An agent that is installed on-premises uses this host name to mount the NFS server in a network.
         * </p>
         * <note>
         * <p>
         * This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
         * </p>
         * </note>
         * 
         * @param serverHostname
         *        The name of the NFS server. This value is the IP address or Domain Name Service (DNS) name of the NFS
         *        server. An agent that is installed on-premises uses this host name to mount the NFS server in a
         *        network. </p> <note>
         *        <p>
         *        This name must either be DNS-compliant or must be an IP version 4 (IPv4) address.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverHostname(String serverHostname);

        /**
         * <p>
         * Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
         * </p>
         * 
         * @param onPremConfig
         *        Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onPremConfig(OnPremConfig onPremConfig);

        /**
         * <p>
         * Contains a list of Amazon Resource Names (ARNs) of agents that are used to connect to an NFS server.
         * </p>
         * This is a convenience that creates an instance of the {@link OnPremConfig.Builder} avoiding the need to
         * create one manually via {@link OnPremConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OnPremConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #onPremConfig(OnPremConfig)}.
         * 
         * @param onPremConfig
         *        a consumer that will call methods on {@link OnPremConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onPremConfig(OnPremConfig)
         */
        default Builder onPremConfig(Consumer<OnPremConfig.Builder> onPremConfig) {
            return onPremConfig(OnPremConfig.builder().applyMutation(onPremConfig).build());
        }

        /**
         * <p>
         * The NFS mount options that DataSync can use to mount your NFS share.
         * </p>
         * 
         * @param mountOptions
         *        The NFS mount options that DataSync can use to mount your NFS share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountOptions(NfsMountOptions mountOptions);

        /**
         * <p>
         * The NFS mount options that DataSync can use to mount your NFS share.
         * </p>
         * This is a convenience that creates an instance of the {@link NfsMountOptions.Builder} avoiding the need to
         * create one manually via {@link NfsMountOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link NfsMountOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #mountOptions(NfsMountOptions)}.
         * 
         * @param mountOptions
         *        a consumer that will call methods on {@link NfsMountOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountOptions(NfsMountOptions)
         */
        default Builder mountOptions(Consumer<NfsMountOptions.Builder> mountOptions) {
            return mountOptions(NfsMountOptions.builder().applyMutation(mountOptions).build());
        }

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to add to the location. The value can be an
         *        empty string. We recommend using tags to name your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagListEntry> tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * 
         * @param tags
         *        The key-value pair that represents the tag that you want to add to the location. The value can be an
         *        empty string. We recommend using tags to name your resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagListEntry... tags);

        /**
         * <p>
         * The key-value pair that represents the tag that you want to add to the location. The value can be an empty
         * string. We recommend using tags to name your resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagListEntry>.Builder} avoiding the need to
         * create one manually via {@link List<TagListEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagListEntry>.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<TagListEntry>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<TagListEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<TagListEntry>)
         */
        Builder tags(Consumer<TagListEntry.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DataSyncRequest.BuilderImpl implements Builder {
        private String subdirectory;

        private String serverHostname;

        private OnPremConfig onPremConfig;

        private NfsMountOptions mountOptions;

        private List<TagListEntry> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLocationNfsRequest model) {
            super(model);
            subdirectory(model.subdirectory);
            serverHostname(model.serverHostname);
            onPremConfig(model.onPremConfig);
            mountOptions(model.mountOptions);
            tags(model.tags);
        }

        public final String getSubdirectory() {
            return subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        public final String getServerHostname() {
            return serverHostname;
        }

        @Override
        public final Builder serverHostname(String serverHostname) {
            this.serverHostname = serverHostname;
            return this;
        }

        public final void setServerHostname(String serverHostname) {
            this.serverHostname = serverHostname;
        }

        public final OnPremConfig.Builder getOnPremConfig() {
            return onPremConfig != null ? onPremConfig.toBuilder() : null;
        }

        @Override
        public final Builder onPremConfig(OnPremConfig onPremConfig) {
            this.onPremConfig = onPremConfig;
            return this;
        }

        public final void setOnPremConfig(OnPremConfig.BuilderImpl onPremConfig) {
            this.onPremConfig = onPremConfig != null ? onPremConfig.build() : null;
        }

        public final NfsMountOptions.Builder getMountOptions() {
            return mountOptions != null ? mountOptions.toBuilder() : null;
        }

        @Override
        public final Builder mountOptions(NfsMountOptions mountOptions) {
            this.mountOptions = mountOptions;
            return this;
        }

        public final void setMountOptions(NfsMountOptions.BuilderImpl mountOptions) {
            this.mountOptions = mountOptions != null ? mountOptions.build() : null;
        }

        public final Collection<TagListEntry.Builder> getTags() {
            return tags != null ? tags.stream().map(TagListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<TagListEntry> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagListEntry... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagListEntry.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagListEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<TagListEntry.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLocationNfsRequest build() {
            return new CreateLocationNfsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
