/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.Setting;
import software.amazon.awssdk.services.directory.model.SettingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSettingsRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, UpdateSettingsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::directoryId)).setter(UpdateSettingsRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<Setting>> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Settings").getter(UpdateSettingsRequest.getter(UpdateSettingsRequest::settings)).setter(UpdateSettingsRequest.setter(Builder::settings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Setting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSettingsRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final List<Setting> settings;

    private UpdateSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.settings = builder.settings;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasSettings() {
        return this.settings != null && !(this.settings instanceof SdkAutoConstructList);
    }

    public final List<Setting> settings() {
        return this.settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSettings() ? this.settings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettingsRequest)) {
            return false;
        }
        UpdateSettingsRequest other = (UpdateSettingsRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasSettings() == other.hasSettings() && Objects.equals(this.settings(), other.settings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSettingsRequest").add("DirectoryId", (Object)this.directoryId()).add("Settings", this.hasSettings() ? this.settings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSettingsRequest, T> g) {
        return obj -> g.apply((UpdateSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<Setting> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSettingsRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.settings(model.settings);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<Setting.Builder> getSettings() {
            List<Setting.Builder> result = SettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<Setting.BuilderImpl> settings) {
            this.settings = SettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<Setting> settings) {
            this.settings = SettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Setting ... settings) {
            this.settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<Setting.Builder> ... settings) {
            this.settings(Stream.of(settings).map(c -> (Setting)((Setting.Builder)Setting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSettingsRequest build() {
            return new UpdateSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSettingsRequest> {
        public Builder directoryId(String var1);

        public Builder settings(Collection<Setting> var1);

        public Builder settings(Setting ... var1);

        public Builder settings(Consumer<Setting.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

