/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.SharedDirectory;

public class DescribeSharedDirectoriesIterable
implements SdkIterable<DescribeSharedDirectoriesResponse> {
    private final DirectoryClient client;
    private final DescribeSharedDirectoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSharedDirectoriesIterable(DirectoryClient client, DescribeSharedDirectoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeSharedDirectoriesResponseFetcher();
    }

    public Iterator<DescribeSharedDirectoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SharedDirectory> sharedDirectories() {
        Function<DescribeSharedDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sharedDirectories() != null) {
                return response.sharedDirectories().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSharedDirectoriesResponseFetcher
    implements SyncPageFetcher<DescribeSharedDirectoriesResponse> {
        private DescribeSharedDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSharedDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSharedDirectoriesResponse nextPage(DescribeSharedDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeSharedDirectoriesIterable.this.client.describeSharedDirectories(DescribeSharedDirectoriesIterable.this.firstRequest);
            }
            return DescribeSharedDirectoriesIterable.this.client.describeSharedDirectories((DescribeSharedDirectoriesRequest)((Object)DescribeSharedDirectoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

