/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableReplicaAutoScalingResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeTableReplicaAutoScalingResponse.Builder, DescribeTableReplicaAutoScalingResponse> {
    private static final SdkField<TableAutoScalingDescription> TABLE_AUTO_SCALING_DESCRIPTION_FIELD = SdkField
            .<TableAutoScalingDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeTableReplicaAutoScalingResponse::tableAutoScalingDescription))
            .setter(setter(Builder::tableAutoScalingDescription))
            .constructor(TableAutoScalingDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableAutoScalingDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TABLE_AUTO_SCALING_DESCRIPTION_FIELD));

    private final TableAutoScalingDescription tableAutoScalingDescription;

    private DescribeTableReplicaAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.tableAutoScalingDescription = builder.tableAutoScalingDescription;
    }

    /**
     * <p>
     * Represents the auto scaling properties of the table.
     * </p>
     * 
     * @return Represents the auto scaling properties of the table.
     */
    public TableAutoScalingDescription tableAutoScalingDescription() {
        return tableAutoScalingDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableAutoScalingDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableReplicaAutoScalingResponse)) {
            return false;
        }
        DescribeTableReplicaAutoScalingResponse other = (DescribeTableReplicaAutoScalingResponse) obj;
        return Objects.equals(tableAutoScalingDescription(), other.tableAutoScalingDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTableReplicaAutoScalingResponse")
                .add("TableAutoScalingDescription", tableAutoScalingDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableAutoScalingDescription":
            return Optional.ofNullable(clazz.cast(tableAutoScalingDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableReplicaAutoScalingResponse, T> g) {
        return obj -> g.apply((DescribeTableReplicaAutoScalingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTableReplicaAutoScalingResponse> {
        /**
         * <p>
         * Represents the auto scaling properties of the table.
         * </p>
         * 
         * @param tableAutoScalingDescription
         *        Represents the auto scaling properties of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableAutoScalingDescription(TableAutoScalingDescription tableAutoScalingDescription);

        /**
         * <p>
         * Represents the auto scaling properties of the table.
         * </p>
         * This is a convenience that creates an instance of the {@link TableAutoScalingDescription.Builder} avoiding
         * the need to create one manually via {@link TableAutoScalingDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableAutoScalingDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #tableAutoScalingDescription(TableAutoScalingDescription)}.
         * 
         * @param tableAutoScalingDescription
         *        a consumer that will call methods on {@link TableAutoScalingDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableAutoScalingDescription(TableAutoScalingDescription)
         */
        default Builder tableAutoScalingDescription(Consumer<TableAutoScalingDescription.Builder> tableAutoScalingDescription) {
            return tableAutoScalingDescription(TableAutoScalingDescription.builder().applyMutation(tableAutoScalingDescription)
                    .build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private TableAutoScalingDescription tableAutoScalingDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableReplicaAutoScalingResponse model) {
            super(model);
            tableAutoScalingDescription(model.tableAutoScalingDescription);
        }

        public final TableAutoScalingDescription.Builder getTableAutoScalingDescription() {
            return tableAutoScalingDescription != null ? tableAutoScalingDescription.toBuilder() : null;
        }

        @Override
        public final Builder tableAutoScalingDescription(TableAutoScalingDescription tableAutoScalingDescription) {
            this.tableAutoScalingDescription = tableAutoScalingDescription;
            return this;
        }

        public final void setTableAutoScalingDescription(TableAutoScalingDescription.BuilderImpl tableAutoScalingDescription) {
            this.tableAutoScalingDescription = tableAutoScalingDescription != null ? tableAutoScalingDescription.build() : null;
        }

        @Override
        public DescribeTableReplicaAutoScalingResponse build() {
            return new DescribeTableReplicaAutoScalingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
