/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a set of primary keys and, for each key, the attributes to retrieve from the table.
 * </p>
 * <p>
 * For each primary key, you must provide <i>all</i> of the key attributes. For example, with a simple primary key, you
 * only need to provide the partition key. For a composite primary key, you must provide <i>both</i> the partition key
 * and the sort key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeysAndAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<KeysAndAttributes.Builder, KeysAndAttributes> {
    private static final SdkField<List<Map<String, AttributeValue>>> KEYS_FIELD = SdkField
            .<List<Map<String, AttributeValue>>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(KeysAndAttributes::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, AttributeValue>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(AttributeValue::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToGet")
            .getter(getter(KeysAndAttributes::attributesToGet))
            .setter(setter(Builder::attributesToGet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConsistentRead").getter(getter(KeysAndAttributes::consistentRead))
            .setter(setter(Builder::consistentRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()).build();

    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectionExpression").getter(getter(KeysAndAttributes::projectionExpression))
            .setter(setter(Builder::projectionExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build())
            .build();

    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ExpressionAttributeNames")
            .getter(getter(KeysAndAttributes::expressionAttributeNames))
            .setter(setter(Builder::expressionAttributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD,
            ATTRIBUTES_TO_GET_FIELD, CONSISTENT_READ_FIELD, PROJECTION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Map<String, AttributeValue>> keys;

    private final List<String> attributesToGet;

    private final Boolean consistentRead;

    private final String projectionExpression;

    private final Map<String, String> expressionAttributeNames;

    private KeysAndAttributes(BuilderImpl builder) {
        this.keys = builder.keys;
        this.attributesToGet = builder.attributesToGet;
        this.consistentRead = builder.consistentRead;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The primary key attribute values that define the items and the attributes associated with the items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The primary key attribute values that define the items and the attributes associated with the items.
     */
    public final List<Map<String, AttributeValue>> keys() {
        return keys;
    }

    /**
     * Returns true if the AttributesToGet property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttributesToGet() {
        return attributesToGet != null && !(attributesToGet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">Legacy
     * Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributesToGet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html">
     *         Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final List<String> attributesToGet() {
        return attributesToGet;
    }

    /**
     * <p>
     * The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used;
     * otherwise, an eventually consistent read is used.
     * </p>
     * 
     * @return The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is
     *         used; otherwise, an eventually consistent read is used.
     */
    public final Boolean consistentRead() {
        return consistentRead;
    }

    /**
     * <p>
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars,
     * sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must be separated
     * by commas.
     * </p>
     * <p>
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are
     * not found, they will not appear in the result.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @return A string that identifies one or more attributes to retrieve from the table. These attributes can include
     *         scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code>
     *         must be separated by commas.</p>
     *         <p>
     *         If no attribute names are specified, then all attributes will be returned. If any of the requested
     *         attributes are not found, they will not appear in the result.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final String projectionExpression() {
        return projectionExpression;
    }

    /**
     * Returns true if the ExpressionAttributeNames property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasExpressionAttributeNames() {
        return expressionAttributeNames != null && !(expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To access an attribute whose name conflicts with a DynamoDB reserved word.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a placeholder for repeating occurrences of an attribute name in an expression.
     * </p>
     * </li>
     * <li>
     * <p>
     * To prevent special characters in an attribute name from being misinterpreted in an expression.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the following
     * attribute name:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Percentile</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For
     * the complete list of reserved words, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
     * <code>ExpressionAttributeNames</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>{"#P":"Percentile"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You could then use this substitution in an expression, as in this example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>#P = :val</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders for
     * the actual value at runtime.
     * </p>
     * </note>
     * <p>
     * For more information on expression attribute names, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExpressionAttributeNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more substitution tokens for attribute names in an expression. The following are some use cases
     *         for using <code>ExpressionAttributeNames</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To access an attribute whose name conflicts with a DynamoDB reserved word.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To create a placeholder for repeating occurrences of an attribute name in an expression.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To prevent special characters in an attribute name from being misinterpreted in an expression.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
     *         following attribute name:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Percentile</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
     *         expression. (For the complete list of reserved words, see <a
     *         href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
     *         Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
     *         following for <code>ExpressionAttributeNames</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>{"#P":"Percentile"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You could then use this substitution in an expression, as in this example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>#P = :val</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
     *         placeholders for the actual value at runtime.
     *         </p>
     *         </note>
     *         <p>
     *         For more information on expression attribute names, see <a href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
     *         >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     */
    public final Map<String, String> expressionAttributeNames() {
        return expressionAttributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToGet() ? attributesToGet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(hasExpressionAttributeNames() ? expressionAttributeNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeysAndAttributes)) {
            return false;
        }
        KeysAndAttributes other = (KeysAndAttributes) obj;
        return hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys())
                && hasAttributesToGet() == other.hasAttributesToGet()
                && Objects.equals(attributesToGet(), other.attributesToGet())
                && Objects.equals(consistentRead(), other.consistentRead())
                && Objects.equals(projectionExpression(), other.projectionExpression())
                && hasExpressionAttributeNames() == other.hasExpressionAttributeNames()
                && Objects.equals(expressionAttributeNames(), other.expressionAttributeNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeysAndAttributes").add("Keys", hasKeys() ? keys() : null)
                .add("AttributesToGet", hasAttributesToGet() ? attributesToGet() : null).add("ConsistentRead", consistentRead())
                .add("ProjectionExpression", projectionExpression())
                .add("ExpressionAttributeNames", hasExpressionAttributeNames() ? expressionAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "AttributesToGet":
            return Optional.ofNullable(clazz.cast(attributesToGet()));
        case "ConsistentRead":
            return Optional.ofNullable(clazz.cast(consistentRead()));
        case "ProjectionExpression":
            return Optional.ofNullable(clazz.cast(projectionExpression()));
        case "ExpressionAttributeNames":
            return Optional.ofNullable(clazz.cast(expressionAttributeNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeysAndAttributes, T> g) {
        return obj -> g.apply((KeysAndAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeysAndAttributes> {
        /**
         * <p>
         * The primary key attribute values that define the items and the attributes associated with the items.
         * </p>
         * 
         * @param keys
         *        The primary key attribute values that define the items and the attributes associated with the items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<? extends Map<String, AttributeValue>> keys);

        /**
         * <p>
         * The primary key attribute values that define the items and the attributes associated with the items.
         * </p>
         * 
         * @param keys
         *        The primary key attribute values that define the items and the attributes associated with the items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, AttributeValue>... keys);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html"
         * >Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html"
         *        >Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(Collection<String> attributesToGet);

        /**
         * <p>
         * This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html"
         * >Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param attributesToGet
         *        This is a legacy parameter. Use <code>ProjectionExpression</code> instead. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html"
         *        >Legacy Conditional Parameters</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToGet(String... attributesToGet);

        /**
         * <p>
         * The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is used;
         * otherwise, an eventually consistent read is used.
         * </p>
         * 
         * @param consistentRead
         *        The consistency of a read operation. If set to <code>true</code>, then a strongly consistent read is
         *        used; otherwise, an eventually consistent read is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consistentRead(Boolean consistentRead);

        /**
         * <p>
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include
         * scalars, sets, or elements of a JSON document. The attributes in the <code>ProjectionExpression</code> must
         * be separated by commas.
         * </p>
         * <p>
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes
         * are not found, they will not appear in the result.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param projectionExpression
         *        A string that identifies one or more attributes to retrieve from the table. These attributes can
         *        include scalars, sets, or elements of a JSON document. The attributes in the
         *        <code>ProjectionExpression</code> must be separated by commas.</p>
         *        <p>
         *        If no attribute names are specified, then all attributes will be returned. If any of the requested
         *        attributes are not found, they will not appear in the result.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionExpression(String projectionExpression);

        /**
         * <p>
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for
         * using <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * To access an attribute whose name conflicts with a DynamoDB reserved word.
         * </p>
         * </li>
         * <li>
         * <p>
         * To create a placeholder for repeating occurrences of an attribute name in an expression.
         * </p>
         * </li>
         * <li>
         * <p>
         * To prevent special characters in an attribute name from being misinterpreted in an expression.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider the
         * following attribute name:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Percentile</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression.
         * (For the complete list of reserved words, see <a
         * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved Words</a>
         * in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the following for
         * <code>ExpressionAttributeNames</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>{"#P":"Percentile"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You could then use this substitution in an expression, as in this example:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>#P = :val</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are placeholders
         * for the actual value at runtime.
         * </p>
         * </note>
         * <p>
         * For more information on expression attribute names, see <a href=
         * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         * >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * </p>
         * 
         * @param expressionAttributeNames
         *        One or more substitution tokens for attribute names in an expression. The following are some use cases
         *        for using <code>ExpressionAttributeNames</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To access an attribute whose name conflicts with a DynamoDB reserved word.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To create a placeholder for repeating occurrences of an attribute name in an expression.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To prevent special characters in an attribute name from being misinterpreted in an expression.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Use the <b>#</b> character in an expression to dereference an attribute name. For example, consider
         *        the following attribute name:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Percentile</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The name of this attribute conflicts with a reserved word, so it cannot be used directly in an
         *        expression. (For the complete list of reserved words, see <a
         *        href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html">Reserved
         *        Words</a> in the <i>Amazon DynamoDB Developer Guide</i>). To work around this, you could specify the
         *        following for <code>ExpressionAttributeNames</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>{"#P":"Percentile"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You could then use this substitution in an expression, as in this example:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>#P = :val</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        Tokens that begin with the <b>:</b> character are <i>expression attribute values</i>, which are
         *        placeholders for the actual value at runtime.
         *        </p>
         *        </note>
         *        <p>
         *        For more information on expression attribute names, see <a href=
         *        "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html"
         *        >Accessing Item Attributes</a> in the <i>Amazon DynamoDB Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expressionAttributeNames(Map<String, String> expressionAttributeNames);
    }

    static final class BuilderImpl implements Builder {
        private List<Map<String, AttributeValue>> keys = DefaultSdkAutoConstructList.getInstance();

        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();

        private Boolean consistentRead;

        private String projectionExpression;

        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KeysAndAttributes model) {
            keys(model.keys);
            attributesToGet(model.attributesToGet);
            consistentRead(model.consistentRead);
            projectionExpression(model.projectionExpression);
            expressionAttributeNames(model.expressionAttributeNames);
        }

        public final Collection<? extends Map<String, AttributeValue>> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        @Override
        public final Builder keys(Collection<? extends Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Map<String, AttributeValue>... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<? extends Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        public final Collection<String> getAttributesToGet() {
            if (attributesToGet instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String... attributesToGet) {
            attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Boolean getConsistentRead() {
            return consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final String getProjectionExpression() {
            return projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        @Override
        public KeysAndAttributes build() {
            return new KeysAndAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
