/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Get
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Get> {
    private static final SdkField<Map<String, AttributeValue>> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Key").getter(Get.getter(Get::key)).setter(Get.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(Get.getter(Get::tableName)).setter(Get.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectionExpression").getter(Get.getter(Get::projectionExpression)).setter(Get.setter(Builder::projectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ExpressionAttributeNames").getter(Get.getter(Get::expressionAttributeNames)).setter(Get.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, TABLE_NAME_FIELD, PROJECTION_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> key;
    private final String tableName;
    private final String projectionExpression;
    private final Map<String, String> expressionAttributeNames;

    private Get(BuilderImpl builder) {
        this.key = builder.key;
        this.tableName = builder.tableName;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    public final boolean hasKey() {
        return this.key != null && !(this.key instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> key() {
        return this.key;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String projectionExpression() {
        return this.projectionExpression;
    }

    public final boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKey() ? this.key() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Get)) {
            return false;
        }
        Get other = (Get)obj;
        return this.hasKey() == other.hasKey() && Objects.equals(this.key(), other.key()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && this.hasExpressionAttributeNames() == other.hasExpressionAttributeNames() && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"Get").add("Key", this.hasKey() ? this.key() : null).add("TableName", (Object)this.tableName()).add("ProjectionExpression", (Object)this.projectionExpression()).add("ExpressionAttributeNames", this.hasExpressionAttributeNames() ? this.expressionAttributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ProjectionExpression": {
                return Optional.ofNullable(clazz.cast(this.projectionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Get, T> g) {
        return obj -> g.apply((Get)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> key = DefaultSdkAutoConstructMap.getInstance();
        private String tableName;
        private String projectionExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Get model) {
            this.key(model.key);
            this.tableName(model.tableName);
            this.projectionExpression(model.projectionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getKey() {
            Map<String, AttributeValue.Builder> result = KeyCopier.copyToBuilder(this.key);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder key(Map<String, AttributeValue> key) {
            this.key = KeyCopier.copy(key);
            return this;
        }

        public final void setKey(Map<String, AttributeValue.BuilderImpl> key) {
            this.key = KeyCopier.copyFromBuilder(key);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            if (this.expressionAttributeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public Get build() {
            return new Get(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Get> {
        public Builder key(Map<String, AttributeValue> var1);

        public Builder tableName(String var1);

        public Builder projectionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);
    }
}

