/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGlobalTableSettingsResponse extends DynamoDbResponse implements
        ToCopyableBuilder<UpdateGlobalTableSettingsResponse.Builder, UpdateGlobalTableSettingsResponse> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableName").getter(getter(UpdateGlobalTableSettingsResponse::globalTableName))
            .setter(setter(Builder::globalTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()).build();

    private static final SdkField<List<ReplicaSettingsDescription>> REPLICA_SETTINGS_FIELD = SdkField
            .<List<ReplicaSettingsDescription>> builder(MarshallingType.LIST)
            .memberName("ReplicaSettings")
            .getter(getter(UpdateGlobalTableSettingsResponse::replicaSettings))
            .setter(setter(Builder::replicaSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicaSettingsDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicaSettingsDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD,
            REPLICA_SETTINGS_FIELD));

    private final String globalTableName;

    private final List<ReplicaSettingsDescription> replicaSettings;

    private UpdateGlobalTableSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicaSettings = builder.replicaSettings;
    }

    /**
     * <p>
     * The name of the global table.
     * </p>
     * 
     * @return The name of the global table.
     */
    public final String globalTableName() {
        return globalTableName;
    }

    /**
     * Returns true if the ReplicaSettings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasReplicaSettings() {
        return replicaSettings != null && !(replicaSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Region-specific settings for the global table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplicaSettings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Region-specific settings for the global table.
     */
    public final List<ReplicaSettingsDescription> replicaSettings() {
        return replicaSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicaSettings() ? replicaSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableSettingsResponse)) {
            return false;
        }
        UpdateGlobalTableSettingsResponse other = (UpdateGlobalTableSettingsResponse) obj;
        return Objects.equals(globalTableName(), other.globalTableName()) && hasReplicaSettings() == other.hasReplicaSettings()
                && Objects.equals(replicaSettings(), other.replicaSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGlobalTableSettingsResponse").add("GlobalTableName", globalTableName())
                .add("ReplicaSettings", hasReplicaSettings() ? replicaSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GlobalTableName":
            return Optional.ofNullable(clazz.cast(globalTableName()));
        case "ReplicaSettings":
            return Optional.ofNullable(clazz.cast(replicaSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalTableSettingsResponse, T> g) {
        return obj -> g.apply((UpdateGlobalTableSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateGlobalTableSettingsResponse> {
        /**
         * <p>
         * The name of the global table.
         * </p>
         * 
         * @param globalTableName
         *        The name of the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableName(String globalTableName);

        /**
         * <p>
         * The Region-specific settings for the global table.
         * </p>
         * 
         * @param replicaSettings
         *        The Region-specific settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettings(Collection<ReplicaSettingsDescription> replicaSettings);

        /**
         * <p>
         * The Region-specific settings for the global table.
         * </p>
         * 
         * @param replicaSettings
         *        The Region-specific settings for the global table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaSettings(ReplicaSettingsDescription... replicaSettings);

        /**
         * <p>
         * The Region-specific settings for the global table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReplicaSettingsDescription>.Builder}
         * avoiding the need to create one manually via {@link List<ReplicaSettingsDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicaSettingsDescription>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicaSettings(List<ReplicaSettingsDescription>)}.
         * 
         * @param replicaSettings
         *        a consumer that will call methods on {@link List<ReplicaSettingsDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicaSettings(List<ReplicaSettingsDescription>)
         */
        Builder replicaSettings(Consumer<ReplicaSettingsDescription.Builder>... replicaSettings);
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private String globalTableName;

        private List<ReplicaSettingsDescription> replicaSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableSettingsResponse model) {
            super(model);
            globalTableName(model.globalTableName);
            replicaSettings(model.replicaSettings);
        }

        public final String getGlobalTableName() {
            return globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final List<ReplicaSettingsDescription.Builder> getReplicaSettings() {
            List<ReplicaSettingsDescription.Builder> result = ReplicaSettingsDescriptionListCopier
                    .copyToBuilder(this.replicaSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder replicaSettings(Collection<ReplicaSettingsDescription> replicaSettings) {
            this.replicaSettings = ReplicaSettingsDescriptionListCopier.copy(replicaSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettings(ReplicaSettingsDescription... replicaSettings) {
            replicaSettings(Arrays.asList(replicaSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaSettings(Consumer<ReplicaSettingsDescription.Builder>... replicaSettings) {
            replicaSettings(Stream.of(replicaSettings).map(c -> ReplicaSettingsDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaSettings(Collection<ReplicaSettingsDescription.BuilderImpl> replicaSettings) {
            this.replicaSettings = ReplicaSettingsDescriptionListCopier.copyFromBuilder(replicaSettings);
        }

        @Override
        public UpdateGlobalTableSettingsResponse build() {
            return new UpdateGlobalTableSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
