/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationConfigurationsResponse extends EfsResponse implements
        ToCopyableBuilder<DescribeReplicationConfigurationsResponse.Builder, DescribeReplicationConfigurationsResponse> {
    private static final SdkField<List<ReplicationConfigurationDescription>> REPLICATIONS_FIELD = SdkField
            .<List<ReplicationConfigurationDescription>> builder(MarshallingType.LIST)
            .memberName("Replications")
            .getter(getter(DescribeReplicationConfigurationsResponse::replications))
            .setter(setter(Builder::replications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationConfigurationDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationConfigurationDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReplicationConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReplicationConfigurationDescription> replications;

    private final String nextToken;

    private DescribeReplicationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.replications = builder.replications;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Replications property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplications() {
        return replications != null && !(replications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The collection of replication configurations that is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplications} method.
     * </p>
     * 
     * @return The collection of replication configurations that is returned.
     */
    public final List<ReplicationConfigurationDescription> replications() {
        return replications;
    }

    /**
     * <p>
     * You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the additional
     * descriptions.
     * </p>
     * 
     * @return You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the
     *         additional descriptions.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasReplications() ? replications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationConfigurationsResponse)) {
            return false;
        }
        DescribeReplicationConfigurationsResponse other = (DescribeReplicationConfigurationsResponse) obj;
        return hasReplications() == other.hasReplications() && Objects.equals(replications(), other.replications())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReplicationConfigurationsResponse")
                .add("Replications", hasReplications() ? replications() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Replications":
            return Optional.ofNullable(clazz.cast(replications()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Replications", REPLICATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationConfigurationsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EfsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationConfigurationsResponse> {
        /**
         * <p>
         * The collection of replication configurations that is returned.
         * </p>
         * 
         * @param replications
         *        The collection of replication configurations that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replications(Collection<ReplicationConfigurationDescription> replications);

        /**
         * <p>
         * The collection of replication configurations that is returned.
         * </p>
         * 
         * @param replications
         *        The collection of replication configurations that is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replications(ReplicationConfigurationDescription... replications);

        /**
         * <p>
         * The collection of replication configurations that is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #replications(List<ReplicationConfigurationDescription>)}.
         * 
         * @param replications
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.efs.model.ReplicationConfigurationDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replications(java.util.Collection<ReplicationConfigurationDescription>)
         */
        Builder replications(Consumer<ReplicationConfigurationDescription.Builder>... replications);

        /**
         * <p>
         * You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the
         * additional descriptions.
         * </p>
         * 
         * @param nextToken
         *        You can use the <code>NextToken</code> from the previous response in a subsequent request to fetch the
         *        additional descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EfsResponse.BuilderImpl implements Builder {
        private List<ReplicationConfigurationDescription> replications = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationConfigurationsResponse model) {
            super(model);
            replications(model.replications);
            nextToken(model.nextToken);
        }

        public final List<ReplicationConfigurationDescription.Builder> getReplications() {
            List<ReplicationConfigurationDescription.Builder> result = ReplicationConfigurationDescriptionsCopier
                    .copyToBuilder(this.replications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplications(Collection<ReplicationConfigurationDescription.BuilderImpl> replications) {
            this.replications = ReplicationConfigurationDescriptionsCopier.copyFromBuilder(replications);
        }

        @Override
        public final Builder replications(Collection<ReplicationConfigurationDescription> replications) {
            this.replications = ReplicationConfigurationDescriptionsCopier.copy(replications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(ReplicationConfigurationDescription... replications) {
            replications(Arrays.asList(replications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replications(Consumer<ReplicationConfigurationDescription.Builder>... replications) {
            replications(Stream.of(replications).map(c -> ReplicationConfigurationDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeReplicationConfigurationsResponse build() {
            return new DescribeReplicationConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
