/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is
 * used for all file system operations performed by NFS clients using the access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PosixUser implements SdkPojo, Serializable, ToCopyableBuilder<PosixUser.Builder, PosixUser> {
    private static final SdkField<Long> UID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Uid")
            .getter(getter(PosixUser::uid)).setter(setter(Builder::uid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uid").build()).build();

    private static final SdkField<Long> GID_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Gid")
            .getter(getter(PosixUser::gid)).setter(setter(Builder::gid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gid").build()).build();

    private static final SdkField<List<Long>> SECONDARY_GIDS_FIELD = SdkField
            .<List<Long>> builder(MarshallingType.LIST)
            .memberName("SecondaryGids")
            .getter(getter(PosixUser::secondaryGids))
            .setter(setter(Builder::secondaryGids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryGids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Long> builder(MarshallingType.LONG)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UID_FIELD, GID_FIELD,
            SECONDARY_GIDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long uid;

    private final Long gid;

    private final List<Long> secondaryGids;

    private PosixUser(BuilderImpl builder) {
        this.uid = builder.uid;
        this.gid = builder.gid;
        this.secondaryGids = builder.secondaryGids;
    }

    /**
     * <p>
     * The POSIX user ID used for all file system operations using this access point.
     * </p>
     * 
     * @return The POSIX user ID used for all file system operations using this access point.
     */
    public final Long uid() {
        return uid;
    }

    /**
     * <p>
     * The POSIX group ID used for all file system operations using this access point.
     * </p>
     * 
     * @return The POSIX group ID used for all file system operations using this access point.
     */
    public final Long gid() {
        return gid;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryGids property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondaryGids() {
        return secondaryGids != null && !(secondaryGids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Secondary POSIX group IDs used for all file system operations using this access point.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryGids} method.
     * </p>
     * 
     * @return Secondary POSIX group IDs used for all file system operations using this access point.
     */
    public final List<Long> secondaryGids() {
        return secondaryGids;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uid());
        hashCode = 31 * hashCode + Objects.hashCode(gid());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryGids() ? secondaryGids() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PosixUser)) {
            return false;
        }
        PosixUser other = (PosixUser) obj;
        return Objects.equals(uid(), other.uid()) && Objects.equals(gid(), other.gid())
                && hasSecondaryGids() == other.hasSecondaryGids() && Objects.equals(secondaryGids(), other.secondaryGids());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PosixUser").add("Uid", uid()).add("Gid", gid())
                .add("SecondaryGids", hasSecondaryGids() ? secondaryGids() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uid":
            return Optional.ofNullable(clazz.cast(uid()));
        case "Gid":
            return Optional.ofNullable(clazz.cast(gid()));
        case "SecondaryGids":
            return Optional.ofNullable(clazz.cast(secondaryGids()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Uid", UID_FIELD);
        map.put("Gid", GID_FIELD);
        map.put("SecondaryGids", SECONDARY_GIDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PosixUser, T> g) {
        return obj -> g.apply((PosixUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PosixUser> {
        /**
         * <p>
         * The POSIX user ID used for all file system operations using this access point.
         * </p>
         * 
         * @param uid
         *        The POSIX user ID used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uid(Long uid);

        /**
         * <p>
         * The POSIX group ID used for all file system operations using this access point.
         * </p>
         * 
         * @param gid
         *        The POSIX group ID used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gid(Long gid);

        /**
         * <p>
         * Secondary POSIX group IDs used for all file system operations using this access point.
         * </p>
         * 
         * @param secondaryGids
         *        Secondary POSIX group IDs used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryGids(Collection<Long> secondaryGids);

        /**
         * <p>
         * Secondary POSIX group IDs used for all file system operations using this access point.
         * </p>
         * 
         * @param secondaryGids
         *        Secondary POSIX group IDs used for all file system operations using this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryGids(Long... secondaryGids);
    }

    static final class BuilderImpl implements Builder {
        private Long uid;

        private Long gid;

        private List<Long> secondaryGids = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PosixUser model) {
            uid(model.uid);
            gid(model.gid);
            secondaryGids(model.secondaryGids);
        }

        public final Long getUid() {
            return uid;
        }

        public final void setUid(Long uid) {
            this.uid = uid;
        }

        @Override
        public final Builder uid(Long uid) {
            this.uid = uid;
            return this;
        }

        public final Long getGid() {
            return gid;
        }

        public final void setGid(Long gid) {
            this.gid = gid;
        }

        @Override
        public final Builder gid(Long gid) {
            this.gid = gid;
            return this;
        }

        public final Collection<Long> getSecondaryGids() {
            if (secondaryGids instanceof SdkAutoConstructList) {
                return null;
            }
            return secondaryGids;
        }

        public final void setSecondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
        }

        @Override
        public final Builder secondaryGids(Collection<Long> secondaryGids) {
            this.secondaryGids = SecondaryGidsCopier.copy(secondaryGids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryGids(Long... secondaryGids) {
            secondaryGids(Arrays.asList(secondaryGids));
            return this;
        }

        @Override
        public PosixUser build() {
            return new PosixUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
